#version 150

in vec4 Position;

layout(std140) uniform Projection
{
    mat4 ProjMat;
};

layout(std140) uniform SamplerInfo
{
    vec2 OutSize;
    vec2 InSize;
};

layout(std140) uniform FxaaConfig
{
    float SubPixelShift;
    float SpanMax;
    float ReduceMul;
};

out vec2 texCoord;
out vec4 posPos;

void main() 
{
    vec4 outPos = ProjMat * vec4(Position.xy * OutSize, 0.0, 1.0);
    gl_Position = vec4(outPos.xy, 0.2, 1.0);

    texCoord = Position.xy;
    
    posPos.xy = texCoord.xy + (0.5/OutSize * vec2(0.5 - SubPixelShift));
    posPos.zw = texCoord.xy - (0.5/OutSize * vec2(0.5 + SubPixelShift));
}
