/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import net.optifine.util.GpuFrameTimer;
import org.lwjgl.opengl.GL;

public class GpuFrameTimer {
    private static boolean timerQuerySupported = GL.getCapabilities().GL_ARB_timer_query;
    private static long lastTimeCpuNs = 0L;
    private static long frameTimeCpuNs = 0L;
    private static TimerQuery timerQuery;
    private static long frameTimeGpuNs;
    private static long lastTimeActiveMs;

    public static void startRender() {
        if (timerQuery != null && timerQuery.hasResult()) {
            long frameTimeNs = timerQuery.getResult();
            frameTimeGpuNs = (frameTimeGpuNs + frameTimeNs) / 2L;
            timerQuery = null;
        }
        if (System.currentTimeMillis() > lastTimeActiveMs + 1000L) {
            return;
        }
        long timeCpuNs = System.nanoTime();
        if (lastTimeCpuNs != 0L) {
            long frameTimeNs = timeCpuNs - lastTimeCpuNs;
            frameTimeCpuNs = (frameTimeCpuNs + frameTimeNs) / 2L;
        }
        lastTimeCpuNs = timeCpuNs;
        if (timerQuery == null && timerQuerySupported) {
            timerQuery = new TimerQuery();
            timerQuery.start();
        }
    }

    public static void finishRender() {
        if (timerQuery != null) {
            timerQuery.finish();
        }
    }

    public static double getGpuLoad() {
        lastTimeActiveMs = System.currentTimeMillis();
        return (double)Math.max(frameTimeGpuNs, 0L) / Math.max((double)frameTimeCpuNs, 1.0);
    }

    static {
        frameTimeGpuNs = 0L;
        lastTimeActiveMs = 0L;
    }
}

