/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.render;

import net.optifine.shaders.Shaders;
import net.optifine.util.MathUtils;
import org.joml.Matrix4f;

public class VertexPosition {
    private int frameId;
    private float posX;
    private float posY;
    private float posZ;
    private float velocityX;
    private float velocityY;
    private float velocityZ;
    private boolean velocityValid;

    public void setPosition(int frameId, float x, float y, float z2) {
        if (Shaders.isShadowPass) {
            return;
        }
        if (frameId == this.frameId) {
            return;
        }
        Matrix4f mv = Shaders.getLastModelView();
        float tx = MathUtils.getTransformX((Matrix4f)mv, (float)x, (float)y, (float)z2);
        float ty = MathUtils.getTransformY((Matrix4f)mv, (float)x, (float)y, (float)z2);
        float tz = MathUtils.getTransformZ((Matrix4f)mv, (float)x, (float)y, (float)z2);
        if (this.frameId != 0) {
            this.velocityX = tx - this.posX;
            this.velocityY = ty - this.posY;
            this.velocityZ = tz - this.posZ;
            this.velocityValid = frameId - this.frameId <= 3 && !Shaders.pointOfViewChanged;
        }
        this.frameId = frameId;
        this.posX = tx;
        this.posY = ty;
        this.posZ = tz;
    }

    public boolean isVelocityValid() {
        return this.velocityValid;
    }

    public float getVelocityX() {
        return this.velocityX;
    }

    public float getVelocityY() {
        return this.velocityY;
    }

    public float getVelocityZ() {
        return this.velocityZ;
    }

    public int getFrameId() {
        return this.frameId;
    }
}

