/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.optifine.Config;
import net.optifine.IRandomEntity;
import net.optifine.RandomEntity;
import net.optifine.RandomEntityContext;
import net.optifine.RandomEntityProperties;
import net.optifine.RandomTileEntity;
import net.optifine.reflect.ReflectorRaw;
import net.optifine.util.ArrayUtils;
import net.optifine.util.ResUtils;
import net.optifine.util.StrUtils;
import net.optifine.util.TextureUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class RandomEntities {
    private static Map<String, RandomEntityProperties<ame>> mapProperties = new HashMap();
    private static Map<String, RandomEntityProperties<ame>> mapSpriteProperties = new HashMap();
    private static boolean active = false;
    private static hec entityRenderDispatcher;
    private static RandomEntity randomEntity;
    private static hab tileEntityRendererDispatcher;
    private static RandomTileEntity randomTileEntity;
    private static boolean working;
    public static final String SUFFIX_PNG = ".png";
    public static final String SUFFIX_PROPERTIES = ".properties";
    public static final String SEPARATOR_DIGITS = ".";
    public static final String PREFIX_TEXTURES_ENTITY = "textures/entity/";
    public static final String PREFIX_TEXTURES_PAINTING = "textures/painting/";
    public static final String PREFIX_TEXTURES = "textures/";
    public static final String PREFIX_OPTIFINE_RANDOM = "optifine/random/";
    public static final String PREFIX_OPTIFINE = "optifine/";
    public static final String PREFIX_OPTIFINE_MOB = "optifine/mob/";
    private static final String[] DEPENDANT_SUFFIXES;
    private static final String PREFIX_DYNAMIC_TEXTURE_HORSE = "horse/";
    private static final String[] HORSE_TEXTURES;
    private static final String[] HORSE_TEXTURES_ABBR;

    public static void entityLoaded(bzm entity, dmu world) {
        if (world == null) {
            return;
        }
        all edm = entity.au();
        edm.spawnPosition = entity.dx();
        edm.spawnBiome = (dnx)world.v(edm.spawnPosition).a();
        if (entity instanceof cnh) {
            cnh esr = (cnh)entity;
            RandomEntities.checkEntityShoulder((cnh)esr, (boolean)false);
        }
    }

    public static void entityUnloaded(bzm entity, dmu world) {
        if (entity instanceof cnh) {
            cnh esr = (cnh)entity;
            RandomEntities.checkEntityShoulder((cnh)esr, (boolean)true);
        }
    }

    public static void checkEntityShoulder(cnh entity, boolean attach) {
        cam owner = entity.U_();
        if (owner == null) {
            owner = Config.getMinecraft().t;
        }
        if (!(owner instanceof gwf)) {
            return;
        }
        gwf player = (gwf)owner;
        UUID entityUuid = entity.cK();
        if (attach) {
            player.lastAttachedEntity = entity;
        } else {
            all edm = entity.au();
            if (player.entityShoulderLeft != null && Config.equals((Object)player.entityShoulderLeft.cK(), (Object)entityUuid)) {
                all edmShoulderLeft = player.entityShoulderLeft.au();
                edm.spawnPosition = edmShoulderLeft.spawnPosition;
                edm.spawnBiome = edmShoulderLeft.spawnBiome;
                player.entityShoulderLeft = null;
            }
            if (player.entityShoulderRight != null && Config.equals((Object)player.entityShoulderRight.cK(), (Object)entityUuid)) {
                all edmShoulderRight = player.entityShoulderRight.au();
                edm.spawnPosition = edmShoulderRight.spawnPosition;
                edm.spawnBiome = edmShoulderRight.spawnBiome;
                player.entityShoulderRight = null;
            }
        }
    }

    public static void worldChanged(dmu oldWorld, dmu newWorld) {
        if (newWorld instanceof grk) {
            grk newWorldClient = (grk)newWorld;
            Iterable entities = newWorldClient.e();
            for (bzm entity : entities) {
                RandomEntities.entityLoaded((bzm)entity, (dmu)newWorld);
            }
        }
        randomEntity.setEntity(null);
        randomTileEntity.setTileEntity(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ame getTextureLocation(ame loc) {
        if (!active) {
            return loc;
        }
        IRandomEntity re = RandomEntities.getRandomEntityRendered();
        if (re == null) {
            return loc;
        }
        if (working) {
            return loc;
        }
        try {
            working = true;
            String name = loc.a();
            if (name.startsWith("horse/")) {
                name = RandomEntities.getHorseTexturePath((String)name, (int)"horse/".length());
            }
            if (!name.startsWith("textures/entity/") && !name.startsWith("textures/painting/")) {
                ame ame2 = loc;
                return ame2;
            }
            RandomEntityProperties props = (RandomEntityProperties)mapProperties.get(name);
            if (props == null) {
                ame ame3 = loc;
                return ame3;
            }
            ame ame4 = (ame)props.getResource(re, (Object)loc);
            return ame4;
        }
        finally {
            working = false;
        }
    }

    private static String getHorseTexturePath(String path, int pos) {
        if (HORSE_TEXTURES == null || HORSE_TEXTURES_ABBR == null) {
            return path;
        }
        for (int i = 0; i < HORSE_TEXTURES_ABBR.length; ++i) {
            String abbr = HORSE_TEXTURES_ABBR[i];
            if (!path.startsWith(abbr, pos)) continue;
            return HORSE_TEXTURES[i];
        }
        return path;
    }

    public static IRandomEntity getRandomEntityRendered() {
        if (entityRenderDispatcher.getRenderedEntity() != null) {
            randomEntity.setEntity(entityRenderDispatcher.getRenderedEntity());
            return randomEntity;
        }
        if (hab.tileEntityRendered != null) {
            eaz te = hab.tileEntityRendered;
            if (te.i() != null) {
                randomTileEntity.setTileEntity(te);
                return randomTileEntity;
            }
        }
        return null;
    }

    public static IRandomEntity getRandomEntity(bzm entityIn) {
        randomEntity.setEntity(entityIn);
        return randomEntity;
    }

    public static IRandomEntity getRandomBlockEntity(eaz tileEntityIn) {
        randomTileEntity.setTileEntity(tileEntityIn);
        return randomTileEntity;
    }

    private static RandomEntityProperties<ame> makeProperties(ame loc, RandomEntityContext.Textures context) {
        RandomEntityProperties props;
        String path = loc.a();
        ame locProps = RandomEntities.getLocationProperties((ame)loc, (boolean)context.isLegacy());
        if (locProps != null && (props = RandomEntityProperties.parse((ame)locProps, (ame)loc, (RandomEntityContext)context)) != null) {
            return props;
        }
        int[] variants = RandomEntities.getLocationsVariants((ame)loc, (boolean)context.isLegacy(), (RandomEntityContext)context);
        if (variants == null) {
            return null;
        }
        String name = context.getConnectedParser().parseName(loc.a());
        return new RandomEntityProperties(name, loc, variants, (RandomEntityContext)context);
    }

    private static ame getLocationProperties(ame loc, boolean legacy) {
        String path;
        String pathBase;
        String pathProps;
        ame locMcp = RandomEntities.getLocationRandom((ame)loc, (boolean)legacy);
        if (locMcp == null) {
            return null;
        }
        String domain = locMcp.b();
        ame locProps = new ame(domain, pathProps = (pathBase = StrUtils.removeSuffix((String)(path = locMcp.a()), (String)".png")) + ".properties");
        if (Config.hasResource((ame)locProps)) {
            return locProps;
        }
        String pathParent = RandomEntities.getParentTexturePath((String)pathBase);
        if (pathParent == null) {
            return null;
        }
        ame locParentProps = new ame(domain, pathParent + ".properties");
        if (Config.hasResource((ame)locParentProps)) {
            return locParentProps;
        }
        return null;
    }

    protected static ame getLocationRandom(ame loc, boolean legacy) {
        String domain = loc.b();
        String path = loc.a();
        if (path.startsWith("optifine/")) {
            return loc;
        }
        String prefixTextures = "textures/";
        String prefixRandom = "optifine/random/";
        if (legacy) {
            prefixTextures = "textures/entity/";
            prefixRandom = "optifine/mob/";
        }
        if (!path.startsWith(prefixTextures)) {
            return null;
        }
        String pathRandom = StrUtils.replacePrefix((String)path, (String)prefixTextures, (String)prefixRandom);
        return new ame(domain, pathRandom);
    }

    private static String getPathBase(String pathRandom) {
        if (pathRandom.startsWith("optifine/random/")) {
            return StrUtils.replacePrefix((String)pathRandom, (String)"optifine/random/", (String)"textures/");
        }
        if (pathRandom.startsWith("optifine/mob/")) {
            return StrUtils.replacePrefix((String)pathRandom, (String)"optifine/mob/", (String)"textures/entity/");
        }
        return null;
    }

    protected static ame getLocationIndexed(ame loc, int index) {
        if (loc == null) {
            return null;
        }
        String path = loc.a();
        int pos = path.lastIndexOf(46);
        if (pos < 0) {
            return null;
        }
        String prefix = path.substring(0, pos);
        String suffix = path.substring(pos);
        String separator = StrUtils.endsWithDigit((String)prefix) ? "." : "";
        String pathNew = prefix + separator + index + suffix;
        ame locNew = new ame(loc.b(), pathNew);
        return locNew;
    }

    private static String getParentTexturePath(String path) {
        for (int i = 0; i < DEPENDANT_SUFFIXES.length; ++i) {
            String suffix = DEPENDANT_SUFFIXES[i];
            if (!path.endsWith(suffix)) continue;
            String pathParent = StrUtils.removeSuffix((String)path, (String)suffix);
            return pathParent;
        }
        return null;
    }

    public static int[] getLocationsVariants(ame loc, boolean legacy, RandomEntityContext context) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        ame locRandom = RandomEntities.getLocationRandom((ame)loc, (boolean)legacy);
        if (locRandom == null) {
            return null;
        }
        for (int i = 1; i < list.size() + 10; ++i) {
            int index = i + 1;
            ame locIndex = RandomEntities.getLocationIndexed((ame)locRandom, (int)index);
            if (!Config.hasResource((ame)locIndex)) continue;
            list.add(index);
        }
        if (list.size() <= 1) {
            return null;
        }
        Integer[] arr = list.toArray(new Integer[list.size()]);
        int[] intArr = ArrayUtils.toPrimitive((Integer[])arr);
        Config.dbg((String)(context.getName() + ": " + loc.a() + ", variants: " + intArr.length));
        return intArr;
    }

    public static void update() {
        entityRenderDispatcher = Config.getEntityRenderDispatcher();
        tileEntityRendererDispatcher = fue.R().as();
        mapProperties.clear();
        mapSpriteProperties.clear();
        active = false;
        if (!Config.isRandomEntities()) {
            return;
        }
        RandomEntities.initialize();
    }

    private static void initialize() {
        String[] prefixes = new String[]{"optifine/random/", "optifine/mob/"};
        String[] suffixes = new String[]{".png", ".properties"};
        String[] pathsRandom = ResUtils.collectFiles((String[])prefixes, (String[])suffixes);
        HashSet<String> basePathsChecked = new HashSet<String>();
        for (int i = 0; i < pathsRandom.length; ++i) {
            RandomEntityProperties props;
            Object path = pathsRandom[i];
            path = StrUtils.removeSuffix((String)path, (String[])suffixes);
            path = StrUtils.trimTrailing((String)path, (String)"0123456789");
            path = StrUtils.removeSuffix((String)path, (String)".");
            String pathBase = RandomEntities.getPathBase((String)(path = (String)path + ".png"));
            if (basePathsChecked.contains(pathBase)) continue;
            basePathsChecked.add(pathBase);
            ame locBase = new ame(pathBase);
            if (!Config.hasResource((ame)locBase) || (props = (RandomEntityProperties)mapProperties.get(pathBase)) != null) continue;
            props = RandomEntities.makeProperties((ame)locBase, (RandomEntityContext.Textures)new RandomEntityContext.Textures(false));
            if (props == null) {
                props = RandomEntities.makeProperties((ame)locBase, (RandomEntityContext.Textures)new RandomEntityContext.Textures(true));
            }
            if (props == null) continue;
            mapProperties.put(pathBase, props);
        }
        active = !mapProperties.isEmpty();
    }

    public static synchronized void registerSprites(ame atlasLocation, Set<ame> spriteLocations) {
        if (mapProperties.isEmpty()) {
            return;
        }
        String prefix = RandomEntities.getTexturePrefix((ame)atlasLocation);
        HashSet<ame> newLocations = new HashSet<ame>();
        for (ame loc : spriteLocations) {
            String pathFull = "textures/" + prefix + loc.a() + ".png";
            RandomEntityProperties props = (RandomEntityProperties)mapProperties.get(pathFull);
            if (props == null) continue;
            mapSpriteProperties.put(loc.a(), props);
            List locs = props.getAllResources();
            if (locs == null) continue;
            for (int i = 0; i < locs.size(); ++i) {
                ame propLoc = (ame)locs.get(i);
                ame locSprite = TextureUtils.getSpriteLocation((ame)propLoc);
                newLocations.add(locSprite);
                mapSpriteProperties.put(locSprite.a(), props);
            }
        }
        spriteLocations.addAll(newLocations);
    }

    private static String getTexturePrefix(ame atlasLocation) {
        if (atlasLocation.a().endsWith("/paintings.png")) {
            return "painting/";
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static hrs getRandomSprite(hrs spriteIn) {
        if (!active) {
            return spriteIn;
        }
        IRandomEntity re = RandomEntities.getRandomEntityRendered();
        if (re == null) {
            return spriteIn;
        }
        if (working) {
            return spriteIn;
        }
        try {
            hrs sprite;
            working = true;
            ame locSpriteIn = spriteIn.getName();
            String name = locSpriteIn.a();
            RandomEntityProperties props = (RandomEntityProperties)mapSpriteProperties.get(name);
            if (props == null) {
                hrs hrs2 = spriteIn;
                return hrs2;
            }
            ame loc = (ame)props.getResource(re, (Object)locSpriteIn);
            if (loc == locSpriteIn) {
                hrs hrs3 = spriteIn;
                return hrs3;
            }
            ame locSprite = TextureUtils.getSpriteLocation((ame)loc);
            hrs hrs4 = sprite = spriteIn.getTextureAtlas().a(locSprite);
            return hrs4;
        }
        finally {
            working = false;
        }
    }

    public static void dbg(String str) {
        Config.dbg((String)("RandomEntities: " + str));
    }

    public static void warn(String str) {
        Config.warn((String)("RandomEntities: " + str));
    }

    static {
        randomEntity = new RandomEntity();
        randomTileEntity = new RandomTileEntity();
        working = false;
        DEPENDANT_SUFFIXES = new String[]{"_armor", "_eyes", "_exploding", "_shooting", "_fur", "_eyes", "_invulnerable", "_angry", "_tame", "_collar"};
        HORSE_TEXTURES = (String[])ReflectorRaw.getFieldValue(null, cos.class, String[].class, (int)0);
        HORSE_TEXTURES_ABBR = (String[])ReflectorRaw.getFieldValue(null, cos.class, String[].class, (int)1);
    }
}

