/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.fabric.startup;

import java.nio.file.Path;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.common.Internal;
import mezz.jei.common.config.InternalKeyMappings;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.network.ClientPacketRouter;
import mezz.jei.common.startup.ConfigData;
import mezz.jei.common.startup.JeiEventHandlers;
import mezz.jei.common.startup.JeiStarter;
import mezz.jei.common.startup.StartData;
import mezz.jei.core.config.IServerConfig;
import mezz.jei.fabric.events.JeiLifecycleEvents;
import mezz.jei.fabric.network.ClientNetworkHandler;
import mezz.jei.fabric.network.ConnectionToServer;
import mezz.jei.fabric.startup.EventRegistration;
import mezz.jei.fabric.startup.FabricPluginFinder;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;
import net.minecraft.class_4013;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientLifecycleHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private final JeiStarter jeiStarter;
    private final EventRegistration eventRegistration;
    private boolean running;

    public ClientLifecycleHandler(Textures textures, IServerConfig serverConfig) {
        FabricLoader fabricLoader = FabricLoader.getInstance();
        Path configDir = fabricLoader.getConfigDir();
        Path jeiConfigDir = configDir.resolve("jei");
        ConnectionToServer serverConnection = new ConnectionToServer();
        InternalKeyMappings keyBindings = new InternalKeyMappings(keyMapping -> {});
        ConfigData configData = ConfigData.create(serverConnection, keyBindings, jeiConfigDir);
        ClientPacketRouter packetRouter = new ClientPacketRouter(serverConnection, serverConfig, configData.worldConfig());
        ClientNetworkHandler.registerClientPacketHandler(packetRouter);
        List<IModPlugin> plugins = FabricPluginFinder.getModPlugins();
        StartData startData = new StartData(plugins, textures, serverConnection, keyBindings, configData);
        this.jeiStarter = new JeiStarter(startData);
        this.eventRegistration = new EventRegistration();
    }

    public void registerEvents() {
        JeiLifecycleEvents.GAME_START.register(() -> JeiLifecycleEvents.AFTER_RECIPE_SYNC.register(() -> {
            if (this.running) {
                this.stopJei();
            }
            this.startJei();
        }));
        JeiLifecycleEvents.GAME_STOP.register(this::stopJei);
    }

    public class_4013 getReloadListener() {
        return resourceManager -> {
            if (this.running) {
                this.stopJei();
                this.startJei();
            }
        };
    }

    private void startJei() {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1687 == null) {
            LOGGER.error("Failed to start JEI, there is no Minecraft client level.");
            return;
        }
        if (this.running) {
            LOGGER.error("Failed to start JEI, it is already running.");
            return;
        }
        JeiEventHandlers handlers = this.jeiStarter.start();
        this.eventRegistration.setEventHandlers(handlers);
        this.running = true;
    }

    private void stopJei() {
        LOGGER.info("Stopping JEI");
        this.eventRegistration.clear();
        Internal.setRuntime(null);
        this.running = false;
    }
}

