/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.plugins.vanilla.compostable;

import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IJeiCompostingRecipe;
import mezz.jei.common.util.Translator;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;

public class CompostableRecipeCategory
implements IRecipeCategory<IJeiCompostingRecipe> {
    public static final int width = 120;
    public static final int height = 18;
    private final IDrawable background;
    private final IDrawable slot;
    private final IDrawable icon;
    private final class_2561 localizedName;

    public CompostableRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(120, 18);
        this.slot = guiHelper.getSlotDrawable();
        this.icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM_STACK, new class_1799((class_1935)class_2246.field_17563));
        this.localizedName = class_2561.method_43471((String)"gui.jei.category.compostable");
    }

    @Override
    public RecipeType<IJeiCompostingRecipe> getRecipeType() {
        return RecipeTypes.COMPOSTING;
    }

    @Override
    public class_2561 getTitle() {
        return this.localizedName;
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, IJeiCompostingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addItemStacks(recipe.getInputs());
    }

    @Override
    public void draw(IJeiCompostingRecipe recipe, IRecipeSlotsView recipeSlotsView, class_4587 poseStack, double mouseX, double mouseY) {
        this.slot.draw(poseStack);
        float chance = recipe.getChance();
        int chancePercent = (int)Math.floor(chance * 100.0f);
        String text = Translator.translateToLocalFormatted("gui.jei.category.compostable.chance", chancePercent);
        class_310 minecraft = class_310.method_1551();
        class_327 font = minecraft.field_1772;
        font.method_1729(poseStack, text, 24.0f, 5.0f, -8355712);
    }
}

