/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.plugins.vanilla.brewing;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.core.collect.SetMultiMap;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;

public class BrewingRecipeUtil {
    public static final class_1799 POTION = new class_1799((class_1935)class_1802.field_8574);
    public static final class_1799 WATER_BOTTLE = class_1844.method_8061((class_1799)POTION.method_7972(), (class_1842)class_1847.field_8991);
    private final Map<String, Integer> brewingStepCache = new HashMap<String, Integer>();
    private final SetMultiMap<String, String> potionMap = new SetMultiMap();
    private final IIngredientHelper<class_1799> itemStackHelper;

    public BrewingRecipeUtil(IIngredientHelper<class_1799> itemStackHelper) {
        this.itemStackHelper = itemStackHelper;
        this.clearCache();
    }

    public void addRecipe(List<class_1799> inputPotions, class_1799 outputPotion) {
        String potionOutputUid = this.itemStackHelper.getUniqueId(outputPotion, UidContext.Recipe);
        for (class_1799 inputPotion : inputPotions) {
            String potionInputUid = this.itemStackHelper.getUniqueId(inputPotion, UidContext.Recipe);
            this.potionMap.put(potionOutputUid, potionInputUid);
        }
        this.clearCache();
    }

    public int getBrewingSteps(class_1799 outputPotion) {
        String potionInputUid = this.itemStackHelper.getUniqueId(outputPotion, UidContext.Recipe);
        return this.getBrewingSteps(potionInputUid, new HashSet<String>());
    }

    private void clearCache() {
        if (this.brewingStepCache.size() != 1) {
            this.brewingStepCache.clear();
            String waterBottleUid = this.itemStackHelper.getUniqueId(WATER_BOTTLE, UidContext.Recipe);
            this.brewingStepCache.put(waterBottleUid, 0);
        }
    }

    private int getBrewingSteps(String potionOutputUid, Set<String> previousSteps) {
        Integer cachedBrewingSteps = this.brewingStepCache.get(potionOutputUid);
        if (cachedBrewingSteps != null) {
            return cachedBrewingSteps;
        }
        if (!previousSteps.add(potionOutputUid)) {
            return Integer.MAX_VALUE;
        }
        Collection prevPotions = this.potionMap.get((Object)potionOutputUid);
        int minPrevSteps = prevPotions.stream().mapToInt(prevPotion -> this.getBrewingSteps((String)prevPotion, previousSteps)).min().orElse(Integer.MAX_VALUE);
        int brewingSteps = minPrevSteps == Integer.MAX_VALUE ? Integer.MAX_VALUE : minPrevSteps + 1;
        this.brewingStepCache.put(potionOutputUid, brewingSteps);
        return brewingSteps;
    }
}

