/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.network.packets;

import com.google.common.base.Preconditions;
import mezz.jei.common.network.IPacketId;
import mezz.jei.common.network.PacketIdServer;
import mezz.jei.common.network.ServerPacketContext;
import mezz.jei.common.network.ServerPacketData;
import mezz.jei.common.network.packets.PacketJei;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.ServerCommandUtil;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2540;

public class PacketSetHotbarItemStack
extends PacketJei {
    private final class_1799 itemStack;
    private final int hotbarSlot;

    public PacketSetHotbarItemStack(class_1799 itemStack, int hotbarSlot) {
        ErrorUtil.checkNotNull(itemStack, "itemStack");
        Preconditions.checkArgument((boolean)class_1661.method_7380((int)hotbarSlot), (Object)("hotbar slot must be in the hotbar. got: " + hotbarSlot));
        this.itemStack = itemStack;
        this.hotbarSlot = hotbarSlot;
    }

    @Override
    public IPacketId getPacketId() {
        return PacketIdServer.SET_HOTBAR_ITEM;
    }

    @Override
    public void writePacketData(class_2540 buf) {
        buf.method_10793(this.itemStack);
        buf.method_10804(this.hotbarSlot);
    }

    public static void readPacketData(ServerPacketData data) {
        class_2540 buf = data.buf();
        class_1799 itemStack = buf.method_10819();
        if (!itemStack.method_7960()) {
            int hotbarSlot = buf.method_10816();
            ServerPacketContext context = data.context();
            ServerCommandUtil.setHotbarSlot(context, itemStack, hotbarSlot);
        }
    }
}

