/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.helpers;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.config.IModIdFormatConfig;
import mezz.jei.common.platform.IPlatformModHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.core.config.IClientConfig;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import org.apache.commons.lang3.StringUtils;

public final class ModIdHelper
implements IModIdHelper {
    private final IClientConfig config;
    private final IModIdFormatConfig modIdFormattingConfig;

    public ModIdHelper(IClientConfig config, IModIdFormatConfig modIdFormattingConfig) {
        this.config = config;
        this.modIdFormattingConfig = modIdFormattingConfig;
    }

    @Override
    public boolean isDisplayingModNameEnabled() {
        String modNameFormat = this.modIdFormattingConfig.getModNameFormat();
        return !modNameFormat.isEmpty();
    }

    @Override
    public <T> List<class_2561> addModNameToIngredientTooltip(List<class_2561> tooltip, T ingredient, IIngredientHelper<T> ingredientHelper) {
        if (this.config.isDebugModeEnabled() && class_310.method_1551().field_1690.field_1827) {
            tooltip = ModIdHelper.addDebugInfo(tooltip, ingredient, ingredientHelper);
        }
        if (!this.isDisplayingModNameEnabled()) {
            return tooltip;
        }
        if (this.modIdFormattingConfig.isModNameFormatOverrideActive() && ingredient instanceof class_1799) {
            return tooltip;
        }
        String modId = ingredientHelper.getDisplayModId(ingredient);
        String modName = this.getFormattedModNameForModId(modId);
        ArrayList<class_2561> tooltipCopy = new ArrayList<class_2561>(tooltip);
        tooltipCopy.add((class_2561)class_2561.method_43470((String)modName));
        return tooltipCopy;
    }

    private static String removeChatFormatting(String string) {
        String withoutFormattingCodes = class_124.method_539((String)string);
        return withoutFormattingCodes == null ? "" : withoutFormattingCodes;
    }

    private static <T> List<class_2561> addDebugInfo(List<class_2561> tooltip, T ingredient, IIngredientHelper<T> ingredientHelper) {
        tooltip = new ArrayList<class_2561>(tooltip);
        class_5250 jeiDebug = class_2561.method_43470((String)"JEI Debug:");
        class_5250 info = class_2561.method_43470((String)("info: " + ingredientHelper.getErrorInfo(ingredient)));
        class_5250 uid = class_2561.method_43470((String)("uid: " + ingredientHelper.getUniqueId(ingredient, UidContext.Ingredient)));
        tooltip.add((class_2561)jeiDebug.method_27692(class_124.field_1080));
        tooltip.add((class_2561)info.method_27692(class_124.field_1080));
        tooltip.add((class_2561)uid.method_27692(class_124.field_1080));
        return tooltip;
    }

    @Override
    public String getFormattedModNameForModId(String modId) {
        String modName = this.getModNameForModId(modId);
        modName = ModIdHelper.removeChatFormatting(modName);
        String modNameFormat = this.modIdFormattingConfig.getModNameFormat();
        if (!modNameFormat.isEmpty()) {
            if (modNameFormat.contains("%MODNAME%")) {
                return StringUtils.replaceOnce((String)modNameFormat, (String)"%MODNAME%", (String)modName);
            }
            return modNameFormat + modName;
        }
        return modName;
    }

    @Override
    public String getModNameForModId(String modId) {
        IPlatformModHelper modHelper = Services.PLATFORM.getModHelper();
        return modHelper.getModNameForModId(modId);
    }
}

