/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui.overlay.bookmarks;

import java.util.Set;
import java.util.stream.Stream;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.common.gui.GuiProperties;
import mezz.jei.common.gui.GuiScreenHelper;
import mezz.jei.common.gui.overlay.bookmarks.ILeftAreaContent;
import mezz.jei.common.input.IClickedIngredient;
import mezz.jei.common.input.IRecipeFocusSource;
import mezz.jei.common.input.IUserInputHandler;
import mezz.jei.common.input.handlers.NullInputHandler;
import mezz.jei.common.input.handlers.ProxyInputHandler;
import mezz.jei.common.util.ImmutableRect2i;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

public class LeftAreaDispatcher
implements IRecipeFocusSource {
    private static final int BORDER_MARGIN = 6;
    private final ILeftAreaContent contents;
    private final GuiScreenHelper guiScreenHelper;
    @Nullable
    private IGuiProperties guiProperties;
    private boolean canShow = false;

    public LeftAreaDispatcher(GuiScreenHelper guiScreenHelper, ILeftAreaContent contents) {
        this.guiScreenHelper = guiScreenHelper;
        this.contents = contents;
    }

    public void drawScreen(class_310 minecraft, class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.canShow) {
            this.contents.drawScreen(minecraft, poseStack, mouseX, mouseY, partialTicks);
        }
    }

    public void drawTooltips(class_310 minecraft, class_4587 poseStack, int mouseX, int mouseY) {
        if (this.canShow) {
            this.contents.drawTooltips(minecraft, poseStack, mouseX, mouseY);
        }
    }

    public void updateScreen(@Nullable class_437 guiScreen, boolean forceUpdate) {
        this.canShow = false;
        IGuiProperties currentGuiProperties = this.guiScreenHelper.getGuiProperties(guiScreen);
        if (currentGuiProperties == null) {
            this.guiProperties = null;
        } else if (forceUpdate || !GuiProperties.areEqual(this.guiProperties, currentGuiProperties)) {
            Set<ImmutableRect2i> guiExclusionAreas = this.guiScreenHelper.getGuiExclusionAreas();
            this.guiProperties = currentGuiProperties;
            ImmutableRect2i displayArea = LeftAreaDispatcher.makeDisplayArea(this.guiProperties);
            if (displayArea.isEmpty()) {
                this.canShow = false;
            } else {
                this.contents.updateBounds(displayArea, guiExclusionAreas);
                this.canShow = true;
            }
        } else {
            this.canShow = true;
        }
    }

    private static ImmutableRect2i makeDisplayArea(IGuiProperties guiProperties) {
        int guiLeft = guiProperties.getGuiLeft();
        int screenHeight = guiProperties.getScreenHeight();
        if (guiLeft <= 12 || screenHeight < 12) {
            return ImmutableRect2i.EMPTY;
        }
        return new ImmutableRect2i(0, 0, guiLeft, screenHeight).insetBy(6);
    }

    @Override
    public Stream<IClickedIngredient<?>> getIngredientUnderMouse(double mouseX, double mouseY) {
        if (this.canShow) {
            return this.contents.getIngredientUnderMouse(mouseX, mouseY);
        }
        return Stream.empty();
    }

    public IUserInputHandler createInputHandler() {
        IUserInputHandler contentsInputHandler = this.contents.createInputHandler();
        return new ProxyInputHandler(() -> {
            if (this.canShow) {
                return contentsInputHandler;
            }
            return NullInputHandler.INSTANCE;
        });
    }
}

