/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGlobalGuiHandler;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.gui.handlers.IScreenHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.common.gui.GuiContainerHandlers;
import mezz.jei.common.ingredients.RegisteredIngredients;
import mezz.jei.common.ingredients.TypedIngredient;
import mezz.jei.common.input.ClickedIngredient;
import mezz.jei.common.input.IClickedIngredient;
import mezz.jei.common.platform.IPlatformScreenHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;

public class GuiScreenHelper {
    private final RegisteredIngredients registeredIngredients;
    private final List<IGlobalGuiHandler> globalGuiHandlers;
    private final GuiContainerHandlers guiContainerHandlers;
    private final Map<Class<?>, IGhostIngredientHandler<?>> ghostIngredientHandlers;
    private final Map<Class<?>, IScreenHandler<?>> guiScreenHandlers;
    private Set<ImmutableRect2i> guiExclusionAreas = Collections.emptySet();

    public GuiScreenHelper(RegisteredIngredients registeredIngredients, List<IGlobalGuiHandler> globalGuiHandlers, GuiContainerHandlers guiContainerHandlers, Map<Class<?>, IGhostIngredientHandler<?>> ghostIngredientHandlers, Map<Class<?>, IScreenHandler<?>> guiScreenHandlers) {
        this.registeredIngredients = registeredIngredients;
        this.globalGuiHandlers = globalGuiHandlers;
        this.guiContainerHandlers = guiContainerHandlers;
        this.ghostIngredientHandlers = ghostIngredientHandlers;
        this.guiScreenHandlers = guiScreenHandlers;
    }

    @Nullable
    public <T extends class_437> IGuiProperties getGuiProperties(@Nullable T screen) {
        if (screen == null) {
            return null;
        }
        IScreenHandler<?> handler = this.guiScreenHandlers.get(screen.getClass());
        if (handler != null) {
            return handler.apply(screen);
        }
        for (Map.Entry<Class<?>, IScreenHandler<?>> entry : this.guiScreenHandlers.entrySet()) {
            IScreenHandler<?> handler2;
            Class<?> guiScreenClass = entry.getKey();
            if (!guiScreenClass.isInstance(screen) || (handler2 = entry.getValue()) == null) continue;
            return handler2.apply(screen);
        }
        return null;
    }

    public boolean updateGuiExclusionAreas(class_437 screen) {
        Set<class_768> guiAreas = this.getPluginsExclusionAreas(screen);
        if (!MathUtil.equalRects(guiAreas, this.guiExclusionAreas)) {
            this.guiExclusionAreas = guiAreas.stream().map(ImmutableRect2i::new).collect(Collectors.toUnmodifiableSet());
            return true;
        }
        return false;
    }

    public Set<ImmutableRect2i> getGuiExclusionAreas() {
        return this.guiExclusionAreas;
    }

    public boolean isInGuiExclusionArea(double mouseX, double mouseY) {
        return MathUtil.contains(this.guiExclusionAreas, mouseX, mouseY);
    }

    private Set<class_768> getPluginsExclusionAreas(class_437 screen) {
        Set<class_768> globalGuiHandlerExclusionAreas = this.globalGuiHandlers.stream().map(IGlobalGuiHandler::getGuiExtraAreas).flatMap(Collection::stream).collect(Collectors.toSet());
        if (screen instanceof class_465) {
            class_465 guiContainer = (class_465)screen;
            Collection<class_768> guiExtraAreas = this.guiContainerHandlers.getGuiExtraAreas(guiContainer);
            HashSet<class_768> areas = new HashSet<class_768>(guiExtraAreas);
            areas.addAll(globalGuiHandlerExclusionAreas);
            return areas;
        }
        return globalGuiHandlerExclusionAreas;
    }

    public <T extends class_465<?>> Stream<IClickedIngredient<?>> getPluginsIngredientUnderMouse(T guiContainer, double mouseX, double mouseY) {
        return Stream.concat(this.guiContainerHandlers.getActiveGuiHandlerStream(guiContainer).map(a -> a.getIngredientUnderMouse(guiContainer, mouseX, mouseY)), this.globalGuiHandlers.stream().map(a -> a.getIngredientUnderMouse(mouseX, mouseY))).map(i -> this.createClickedIngredient(i, guiContainer)).flatMap(Optional::stream);
    }

    @Nullable
    public <T extends class_437> IGhostIngredientHandler<T> getGhostIngredientHandler(T guiScreen) {
        IGhostIngredientHandler<?> handler = this.ghostIngredientHandlers.get(guiScreen.getClass());
        if (handler != null) {
            return handler;
        }
        for (Map.Entry<Class<?>, IGhostIngredientHandler<?>> entry : this.ghostIngredientHandlers.entrySet()) {
            IGhostIngredientHandler<?> handler2;
            Class<?> guiScreenClass = entry.getKey();
            if (!guiScreenClass.isInstance(guiScreen) || (handler2 = entry.getValue()) == null) continue;
            return handler2;
        }
        return null;
    }

    private <T> Optional<IClickedIngredient<?>> createClickedIngredient(@Nullable T ingredient, class_465<?> guiContainer) {
        if (ingredient == null) {
            return Optional.empty();
        }
        return TypedIngredient.create(this.registeredIngredients, ingredient).map(typedIngredient -> {
            ImmutableRect2i area = GuiScreenHelper.getSlotArea(typedIngredient, guiContainer);
            return new ClickedIngredient(typedIngredient, area, false, false);
        });
    }

    public Optional<IGuiClickableArea> getGuiClickableArea(class_465<?> guiContainer, double guiMouseX, double guiMouseY) {
        return this.guiContainerHandlers.getGuiClickableArea(guiContainer, guiMouseX, guiMouseY);
    }

    @Nullable
    public static <T> ImmutableRect2i getSlotArea(ITypedIngredient<T> typedIngredient, class_465<?> guiContainer) {
        IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
        class_1735 slotUnderMouse = screenHelper.getSlotUnderMouse(guiContainer);
        if (slotUnderMouse == null) {
            return null;
        }
        return typedIngredient.getIngredient(VanillaTypes.ITEM_STACK).filter(i -> class_1799.method_7973((class_1799)slotUnderMouse.method_7677(), (class_1799)i)).map(i -> new ImmutableRect2i(screenHelper.getGuiLeft(guiContainer) + slotUnderMouse.field_7873, screenHelper.getGuiTop(guiContainer) + slotUnderMouse.field_7872, 16, 16)).orElse(null);
    }
}

