/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.config;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.bookmarks.BookmarkList;
import mezz.jei.common.config.IBookmarkConfig;
import mezz.jei.common.ingredients.IngredientInfo;
import mezz.jei.common.ingredients.RegisteredIngredients;
import mezz.jei.common.ingredients.TypedIngredient;
import mezz.jei.common.util.ServerConfigPathUtil;
import mezz.jei.core.util.PathUtil;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class BookmarkConfig
implements IBookmarkConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String MARKER_OTHER = "O:";
    private static final String MARKER_STACK = "T:";
    private final Path jeiConfigurationDir;

    @Nullable
    private static Path getPath(Path jeiConfigurationDir) {
        Path configPath = ServerConfigPathUtil.getWorldPath(jeiConfigurationDir);
        if (configPath == null) {
            return null;
        }
        try {
            configPath = Files.createDirectories(configPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("Unable to create bookmark config folder: {}", (Object)configPath);
            return null;
        }
        return configPath.resolve("bookmarks.ini");
    }

    private static Path getOldPath(Path jeiConfigurationDir) {
        return jeiConfigurationDir.resolve("bookmarks.ini");
    }

    public BookmarkConfig(Path jeiConfigurationDir) {
        this.jeiConfigurationDir = jeiConfigurationDir;
    }

    @Override
    public void saveBookmarks(RegisteredIngredients registeredIngredients, List<ITypedIngredient<?>> ingredientList) {
        Path path = BookmarkConfig.getPath(this.jeiConfigurationDir);
        if (path == null) {
            return;
        }
        ArrayList<CallSite> strings = new ArrayList<CallSite>();
        for (ITypedIngredient<?> typedIngredient : ingredientList) {
            Object obj = typedIngredient.getIngredient();
            if (obj instanceof class_1799) {
                class_1799 stack = (class_1799)obj;
                strings.add((CallSite)((Object)(MARKER_STACK + stack.method_7953(new class_2487()))));
                continue;
            }
            strings.add((CallSite)((Object)(MARKER_OTHER + BookmarkConfig.getUid(registeredIngredients, typedIngredient))));
        }
        try {
            Files.write(path, strings, new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save bookmarks list to file {}", (Object)path, (Object)e);
        }
    }

    @Override
    public void loadBookmarks(RegisteredIngredients registeredIngredients, BookmarkList bookmarkList) {
        List<String> ingredientJsonStrings;
        Path path = BookmarkConfig.getPath(this.jeiConfigurationDir);
        if (path == null) {
            return;
        }
        if (!Files.exists(path, new LinkOption[0])) {
            Path oldPath = BookmarkConfig.getOldPath(this.jeiConfigurationDir);
            try {
                if (PathUtil.migrateConfigLocation(path, oldPath)) {
                    LOGGER.info("Successfully migrated config file from '{}' to new location '{}'", (Object)oldPath, (Object)path);
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to migrate config file from '{}' to new location '{}'", (Object)oldPath, (Object)path, (Object)e);
            }
        }
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        try {
            ingredientJsonStrings = Files.readAllLines(path);
        }
        catch (IOException e) {
            LOGGER.error("Failed to load bookmarks from file {}", (Object)path, (Object)e);
            return;
        }
        ArrayList otherIngredientTypes = new ArrayList(registeredIngredients.getIngredientTypes());
        otherIngredientTypes.remove(VanillaTypes.ITEM_STACK);
        IIngredientHelper<class_1799> itemStackHelper = registeredIngredients.getIngredientHelper(VanillaTypes.ITEM_STACK);
        for (String ingredientJsonString : ingredientJsonStrings) {
            if (ingredientJsonString.startsWith(MARKER_STACK)) {
                String itemStackAsJson = ingredientJsonString.substring(MARKER_STACK.length());
                try {
                    class_2487 itemStackAsNbt = class_2522.method_10718((String)itemStackAsJson);
                    class_1799 itemStack = class_1799.method_7915((class_2487)itemStackAsNbt);
                    if (!itemStack.method_7960()) {
                        class_1799 normalized = itemStackHelper.normalizeIngredient(itemStack);
                        Optional<ITypedIngredient<class_1799>> typedIngredient = TypedIngredient.createTyped(registeredIngredients, VanillaTypes.ITEM_STACK, normalized);
                        if (typedIngredient.isEmpty()) {
                            LOGGER.warn("Failed to load bookmarked ItemStack from json string, the item no longer exists:\n{}", (Object)itemStackAsJson);
                            continue;
                        }
                        bookmarkList.addToList(typedIngredient.get(), false);
                        continue;
                    }
                    LOGGER.warn("Failed to load bookmarked ItemStack from json string, the item no longer exists:\n{}", (Object)itemStackAsJson);
                }
                catch (CommandSyntaxException e) {
                    LOGGER.error("Failed to load bookmarked ItemStack from json string:\n{}", (Object)itemStackAsJson, (Object)e);
                }
                continue;
            }
            if (ingredientJsonString.startsWith(MARKER_OTHER)) {
                String uid = ingredientJsonString.substring(MARKER_OTHER.length());
                Optional<ITypedIngredient<?>> typedIngredient = BookmarkConfig.getNormalizedIngredientByUid(registeredIngredients, otherIngredientTypes, uid);
                if (typedIngredient.isEmpty()) {
                    LOGGER.error("Failed to load unknown bookmarked ingredient:\n{}", (Object)ingredientJsonString);
                    continue;
                }
                bookmarkList.addToList(typedIngredient.get(), false);
                continue;
            }
            LOGGER.error("Failed to load unknown bookmarked ingredient:\n{}", (Object)ingredientJsonString);
        }
        bookmarkList.notifyListenersOfChange();
    }

    private static <T> String getUid(RegisteredIngredients registeredIngredients, ITypedIngredient<T> typedIngredient) {
        IIngredientHelper<T> ingredientHelper = registeredIngredients.getIngredientHelper(typedIngredient.getType());
        return ingredientHelper.getUniqueId(typedIngredient.getIngredient(), UidContext.Ingredient);
    }

    private static Optional<ITypedIngredient<?>> getNormalizedIngredientByUid(RegisteredIngredients registeredIngredients, Collection<IIngredientType<?>> ingredientTypes, String uid) {
        return ingredientTypes.stream().map(t -> BookmarkConfig.getNormalizedIngredientByUid(registeredIngredients, t, uid)).flatMap(Optional::stream).findFirst();
    }

    private static <T> Optional<ITypedIngredient<?>> getNormalizedIngredientByUid(RegisteredIngredients registeredIngredients, IIngredientType<T> ingredientType, String uid) {
        IngredientInfo<T> ingredientInfo = registeredIngredients.getIngredientInfo(ingredientType);
        T ingredient = ingredientInfo.getIngredientByUid(uid);
        return Optional.ofNullable(ingredient).map(i -> {
            IIngredientHelper<Object> ingredientHelper = registeredIngredients.getIngredientHelper(ingredientType);
            return ingredientHelper.normalizeIngredient(i);
        }).flatMap(i -> TypedIngredient.createTyped(registeredIngredients, ingredientType, i));
    }
}

