/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.core;

import com.mrcrayfish.furniture.client.MailBoxEntry;
import com.mrcrayfish.furniture.inventory.container.CrateMenu;
import com.mrcrayfish.furniture.inventory.container.FreezerMenu;
import com.mrcrayfish.furniture.inventory.container.MailBoxMenu;
import com.mrcrayfish.furniture.inventory.container.PostBoxMenu;
import com.mrcrayfish.furniture.tileentity.CrateBlockEntity;
import com.mrcrayfish.furniture.tileentity.FreezerBlockEntity;
import com.mrcrayfish.furniture.tileentity.MailBoxBlockEntity;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModContainers {
    public static final DeferredRegister<MenuType<?>> REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"cfm");
    public static final RegistryObject<MenuType<CrateMenu>> CRATE = ModContainers.register("crate", (windowId, playerInventory, data) -> {
        CrateBlockEntity crateBlockEntity = (CrateBlockEntity)playerInventory.f_35978_.f_19853_.m_7702_(data.m_130135_());
        return new CrateMenu(windowId, playerInventory, crateBlockEntity, crateBlockEntity.isLocked());
    });
    public static final RegistryObject<MenuType<PostBoxMenu>> POST_BOX = ModContainers.register("post_box", (windowId, playerInventory, data) -> {
        CompoundTag compound = Objects.requireNonNull(data.m_130260_());
        ArrayList<MailBoxEntry> entries = new ArrayList<MailBoxEntry>();
        ListTag mailBoxList = compound.m_128437_("MailBoxes", 10);
        mailBoxList.forEach(nbt -> entries.add(new MailBoxEntry((CompoundTag)nbt)));
        return new PostBoxMenu(windowId, playerInventory, entries);
    });
    public static final RegistryObject<MenuType<MailBoxMenu>> MAIL_BOX = ModContainers.register("mail_box", (windowId, playerInventory, data) -> {
        MailBoxBlockEntity mailBoxBlockEntity = (MailBoxBlockEntity)playerInventory.f_35978_.f_19853_.m_7702_(data.m_130135_());
        return new MailBoxMenu(windowId, playerInventory, mailBoxBlockEntity);
    });
    public static final RegistryObject<MenuType<FreezerMenu>> FREEZER = ModContainers.register("freezer", (windowId, playerInventory, data) -> {
        FreezerBlockEntity freezerBlockEntity = (FreezerBlockEntity)playerInventory.f_35978_.f_19853_.m_7702_(data.m_130135_());
        return new FreezerMenu(windowId, playerInventory, freezerBlockEntity);
    });

    private static <T extends AbstractContainerMenu> RegistryObject<MenuType<T>> register(String key, MenuType.MenuSupplier<T> supplier) {
        return REGISTER.register(key, () -> new MenuType(supplier, FeatureFlags.f_244332_));
    }
}

