/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.core.ModSounds;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlindsBlock
extends FurnitureHorizontalBlock {
    public static final BooleanProperty OPEN = BooleanProperty.m_61465_((String)"open");
    public static final BooleanProperty EXTENSION = BooleanProperty.m_61465_((String)"extension");
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public BlindsBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true))).m_61124_((Property)EXTENSION, (Comparable)Boolean.valueOf(false)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_());
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] BOX = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0), Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.m_61143_((Property)DIRECTION);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(BOX[direction.m_122416_()]);
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public boolean m_49967_() {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return VoxelShapeHelper.rotate(VoxelShapeHelper.rotate(Block.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0), Direction.SOUTH), (Direction)state.m_61143_((Property)DIRECTION));
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        return this.getBlindState(state, (LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return this.getBlindState(stateIn, level, currentPos);
    }

    private BlockState getBlindState(BlockState state, LevelAccessor level, BlockPos pos) {
        BlockState aboveState = level.m_8055_(pos.m_7494_());
        boolean isExtension = aboveState.m_60734_() == this && aboveState.m_61143_((Property)DIRECTION) == state.m_61143_((Property)DIRECTION);
        return (BlockState)state.m_61124_((Property)EXTENSION, (Comparable)Boolean.valueOf(isExtension));
    }

    public boolean m_7923_(BlockState state) {
        return (Boolean)state.m_61143_((Property)OPEN) == false;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        this.toggleBlinds(level, pos, (Boolean)state.m_61143_((Property)OPEN) == false, (Direction)state.m_61143_((Property)DIRECTION), 5);
        if (!level.m_5776_()) {
            if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
                level.m_5594_(null, pos, (SoundEvent)ModSounds.BLOCK_BLINDS_CLOSE.get(), SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.8f);
            } else {
                level.m_5594_(null, pos, (SoundEvent)ModSounds.BLOCK_BLINDS_OPEN.get(), SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private void toggleBlinds(Level level, BlockPos pos, boolean targetOpen, Direction targetDirection, int depth) {
        if (depth <= 0) {
            return;
        }
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() == this) {
            boolean open = (Boolean)state.m_61143_((Property)OPEN);
            Direction direction = (Direction)state.m_61143_((Property)DIRECTION);
            if (open != targetOpen && direction.equals((Object)targetDirection)) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(targetOpen)), 3);
                this.toggleBlinds(level, pos.m_121945_(targetDirection.m_122427_()), targetOpen, targetDirection, depth - 1);
                this.toggleBlinds(level, pos.m_121945_(targetDirection.m_122428_()), targetOpen, targetDirection, depth - 1);
                this.toggleBlinds(level, pos.m_121945_(Direction.UP), targetOpen, targetDirection, depth - 1);
                this.toggleBlinds(level, pos.m_121945_(Direction.DOWN), targetOpen, targetDirection, depth - 1);
            }
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{OPEN});
        builder.m_61104_(new Property[]{EXTENSION});
    }
}

