/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import javax.imageio.ImageIO;
import net.optifine.BlockPosM;
import net.optifine.Config;
import net.optifine.CustomColorFader;
import net.optifine.CustomColormap;
import net.optifine.CustomColors;
import net.optifine.LightMap;
import net.optifine.LightMapPack;
import net.optifine.config.ConnectedParser;
import net.optifine.config.MatchBlock;
import net.optifine.render.RenderEnv;
import net.optifine.util.BiomeUtils;
import net.optifine.util.EntityUtils;
import net.optifine.util.PotionUtils;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.ResUtils;
import net.optifine.util.StrUtils;
import net.optifine.util.TextureUtils;
import net.optifine.util.WorldUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

/*
 * Exception performing whole class analysis ignored.
 */
public class CustomColors {
    private static String paletteFormatDefault = "vanilla";
    private static CustomColormap waterColors = null;
    private static CustomColormap foliagePineColors = null;
    private static CustomColormap foliageBirchColors = null;
    private static CustomColormap swampFoliageColors = null;
    private static CustomColormap swampGrassColors = null;
    private static CustomColormap[] colorsBlockColormaps = null;
    private static CustomColormap[][] blockColormaps = null;
    private static CustomColormap skyColors = null;
    private static CustomColorFader skyColorFader = new CustomColorFader();
    private static CustomColormap fogColors = null;
    private static CustomColorFader fogColorFader = new CustomColorFader();
    private static CustomColormap underwaterColors = null;
    private static CustomColorFader underwaterColorFader = new CustomColorFader();
    private static CustomColormap underlavaColors = null;
    private static CustomColorFader underlavaColorFader = new CustomColorFader();
    private static LightMapPack[] lightMapPacks = null;
    private static int lightmapMinDimensionId = 0;
    private static CustomColormap redstoneColors = null;
    private static CustomColormap xpOrbColors = null;
    private static int xpOrbTime = -1;
    private static CustomColormap durabilityColors = null;
    private static CustomColormap stemColors = null;
    private static CustomColormap stemMelonColors = null;
    private static CustomColormap stemPumpkinColors = null;
    private static CustomColormap lavaDropColors = null;
    private static CustomColormap myceliumParticleColors = null;
    private static boolean useDefaultGrassFoliageColors = true;
    private static int particleWaterColor = -1;
    private static int particlePortalColor = -1;
    private static int lilyPadColor = -1;
    private static int expBarTextColor = -1;
    private static int bossTextColor = -1;
    private static int signTextColor = -1;
    private static dvt fogColorNether = null;
    private static dvt fogColorEnd = null;
    private static dvt skyColorEnd = null;
    private static int[] spawnEggPrimaryColors = null;
    private static int[] spawnEggSecondaryColors = null;
    private static float[][] wolfCollarColors = null;
    private static float[][] sheepColors = null;
    private static int[] textColors = null;
    private static int[] mapColorsOriginal = null;
    private static float[][] dyeColorsOriginal = null;
    private static int[] potionColors = null;
    private static final cur BLOCK_STATE_DIRT = cix.j.m();
    private static final cur BLOCK_STATE_WATER = cix.C.m();
    public static Random random = new Random();
    private static final IColorizer COLORIZER_GRASS = new /* Unavailable Anonymous Inner Class!! */;
    private static final IColorizer COLORIZER_FOLIAGE = new /* Unavailable Anonymous Inner Class!! */;
    private static final IColorizer COLORIZER_FOLIAGE_PINE = new /* Unavailable Anonymous Inner Class!! */;
    private static final IColorizer COLORIZER_FOLIAGE_BIRCH = new /* Unavailable Anonymous Inner Class!! */;
    private static final IColorizer COLORIZER_WATER = new /* Unavailable Anonymous Inner Class!! */;

    public static void update() {
        paletteFormatDefault = "vanilla";
        waterColors = null;
        foliageBirchColors = null;
        foliagePineColors = null;
        swampGrassColors = null;
        swampFoliageColors = null;
        skyColors = null;
        fogColors = null;
        underwaterColors = null;
        underlavaColors = null;
        redstoneColors = null;
        xpOrbColors = null;
        xpOrbTime = -1;
        durabilityColors = null;
        stemColors = null;
        lavaDropColors = null;
        myceliumParticleColors = null;
        lightMapPacks = null;
        particleWaterColor = -1;
        particlePortalColor = -1;
        lilyPadColor = -1;
        expBarTextColor = -1;
        bossTextColor = -1;
        signTextColor = -1;
        fogColorNether = null;
        fogColorEnd = null;
        skyColorEnd = null;
        colorsBlockColormaps = null;
        blockColormaps = null;
        useDefaultGrassFoliageColors = true;
        spawnEggPrimaryColors = null;
        spawnEggSecondaryColors = null;
        wolfCollarColors = null;
        sheepColors = null;
        textColors = null;
        CustomColors.setMapColors((int[])mapColorsOriginal);
        CustomColors.setDyeColors((float[][])dyeColorsOriginal);
        potionColors = null;
        paletteFormatDefault = CustomColors.getValidProperty((String)"optifine/color.properties", (String)"palette.format", (String[])CustomColormap.FORMAT_STRINGS, (String)"vanilla");
        String mcpColormap = "optifine/colormap/";
        String[] waterPaths = new String[]{"water.png", "watercolorx.png"};
        waterColors = CustomColors.getCustomColors((String)mcpColormap, (String[])waterPaths, (int)256, (int)-1);
        CustomColors.updateUseDefaultGrassFoliageColors();
        if (!Config.isCustomColors()) {
            return;
        }
        String[] pinePaths = new String[]{"pine.png", "pinecolor.png"};
        foliagePineColors = CustomColors.getCustomColors((String)mcpColormap, (String[])pinePaths, (int)256, (int)-1);
        String[] birchPaths = new String[]{"birch.png", "birchcolor.png"};
        foliageBirchColors = CustomColors.getCustomColors((String)mcpColormap, (String[])birchPaths, (int)256, (int)-1);
        String[] swampGrassPaths = new String[]{"swampgrass.png", "swampgrasscolor.png"};
        swampGrassColors = CustomColors.getCustomColors((String)mcpColormap, (String[])swampGrassPaths, (int)256, (int)-1);
        String[] swampFoliagePaths = new String[]{"swampfoliage.png", "swampfoliagecolor.png"};
        swampFoliageColors = CustomColors.getCustomColors((String)mcpColormap, (String[])swampFoliagePaths, (int)256, (int)-1);
        String[] sky0Paths = new String[]{"sky0.png", "skycolor0.png"};
        skyColors = CustomColors.getCustomColors((String)mcpColormap, (String[])sky0Paths, (int)256, (int)-1);
        String[] fog0Paths = new String[]{"fog0.png", "fogcolor0.png"};
        fogColors = CustomColors.getCustomColors((String)mcpColormap, (String[])fog0Paths, (int)256, (int)-1);
        String[] underwaterPaths = new String[]{"underwater.png", "underwatercolor.png"};
        underwaterColors = CustomColors.getCustomColors((String)mcpColormap, (String[])underwaterPaths, (int)256, (int)-1);
        String[] underlavaPaths = new String[]{"underlava.png", "underlavacolor.png"};
        underlavaColors = CustomColors.getCustomColors((String)mcpColormap, (String[])underlavaPaths, (int)256, (int)-1);
        String[] redstonePaths = new String[]{"redstone.png", "redstonecolor.png"};
        redstoneColors = CustomColors.getCustomColors((String)mcpColormap, (String[])redstonePaths, (int)16, (int)1);
        xpOrbColors = CustomColors.getCustomColors((String)(mcpColormap + "xporb.png"), (int)-1, (int)-1);
        durabilityColors = CustomColors.getCustomColors((String)(mcpColormap + "durability.png"), (int)-1, (int)-1);
        String[] stemPaths = new String[]{"stem.png", "stemcolor.png"};
        stemColors = CustomColors.getCustomColors((String)mcpColormap, (String[])stemPaths, (int)8, (int)1);
        stemPumpkinColors = CustomColors.getCustomColors((String)(mcpColormap + "pumpkinstem.png"), (int)8, (int)1);
        stemMelonColors = CustomColors.getCustomColors((String)(mcpColormap + "melonstem.png"), (int)8, (int)1);
        lavaDropColors = CustomColors.getCustomColors((String)(mcpColormap + "lavadrop.png"), (int)-1, (int)1);
        String[] myceliumPaths = new String[]{"myceliumparticle.png", "myceliumparticlecolor.png"};
        myceliumParticleColors = CustomColors.getCustomColors((String)mcpColormap, (String[])myceliumPaths, (int)-1, (int)-1);
        Pair lightMaps = CustomColors.parseLightMapPacks();
        lightMapPacks = (LightMapPack[])lightMaps.getLeft();
        lightmapMinDimensionId = (Integer)lightMaps.getRight();
        CustomColors.readColorProperties((String)"optifine/color.properties");
        blockColormaps = CustomColors.readBlockColormaps((String[])new String[]{mcpColormap + "custom/", mcpColormap + "blocks/"}, (CustomColormap[])colorsBlockColormaps, (int)256, (int)-1);
        CustomColors.updateUseDefaultGrassFoliageColors();
    }

    private static String getValidProperty(String fileName, String key, String[] validValues, String valDef) {
        try {
            aaj loc = new aaj(fileName);
            InputStream in = Config.getResourceStream((aaj)loc);
            if (in == null) {
                return valDef;
            }
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            String val = props.getProperty(key);
            if (val == null) {
                return valDef;
            }
            List<String> listValidValues = Arrays.asList(validValues);
            if (!listValidValues.contains(val)) {
                CustomColors.warn((String)("Invalid value: " + key + "=" + val));
                CustomColors.warn((String)("Expected values: " + Config.arrayToString((Object[])validValues)));
                return valDef;
            }
            CustomColors.dbg((String)(key + "=" + val));
            return val;
        }
        catch (FileNotFoundException e) {
            return valDef;
        }
        catch (IOException e) {
            e.printStackTrace();
            return valDef;
        }
    }

    private static Pair<LightMapPack[], Integer> parseLightMapPacks() {
        String lightmapPrefix = "optifine/lightmap/world";
        String lightmapSuffix = ".png";
        String[] pathsLightmap = ResUtils.collectFiles((String)lightmapPrefix, (String)lightmapSuffix);
        HashMap<Integer, String> mapLightmaps = new HashMap<Integer, String>();
        for (int i = 0; i < pathsLightmap.length; ++i) {
            String path = pathsLightmap[i];
            String dimIdStr = StrUtils.removePrefixSuffix((String)path, (String)lightmapPrefix, (String)lightmapSuffix);
            int dimId = Config.parseInt((String)dimIdStr, (int)Integer.MIN_VALUE);
            if (dimId == Integer.MIN_VALUE) {
                CustomColors.warn((String)("Invalid dimension ID: " + dimIdStr + ", path: " + path));
                continue;
            }
            mapLightmaps.put(dimId, path);
        }
        Set setDimIds = mapLightmaps.keySet();
        Object[] dimIds = setDimIds.toArray(new Integer[setDimIds.size()]);
        Arrays.sort(dimIds);
        if (dimIds.length <= 0) {
            return new ImmutablePair(null, (Object)0);
        }
        int minDimId = (Integer)dimIds[0];
        int maxDimId = (Integer)dimIds[dimIds.length - 1];
        int countDim = maxDimId - minDimId + 1;
        CustomColormap[] colormaps = new CustomColormap[countDim];
        for (int i = 0; i < dimIds.length; ++i) {
            Object dimId = dimIds[i];
            String path = (String)mapLightmaps.get(dimId);
            CustomColormap colors = CustomColors.getCustomColors((String)path, (int)-1, (int)-1);
            if (colors == null) continue;
            if (colors.getWidth() < 16) {
                CustomColors.warn((String)("Invalid lightmap width: " + colors.getWidth() + ", path: " + path));
                continue;
            }
            int lightmapIndex = (Integer)dimId - minDimId;
            colormaps[lightmapIndex] = colors;
        }
        LightMapPack[] lmps = new LightMapPack[colormaps.length];
        for (int i = 0; i < colormaps.length; ++i) {
            LightMapPack lmp;
            CustomColormap cm = colormaps[i];
            if (cm == null) continue;
            String name = cm.name;
            String basePath = cm.basePath;
            CustomColormap cmRain = CustomColors.getCustomColors((String)(basePath + "/" + name + "_rain.png"), (int)-1, (int)-1);
            CustomColormap cmThunder = CustomColors.getCustomColors((String)(basePath + "/" + name + "_thunder.png"), (int)-1, (int)-1);
            LightMap lm = new LightMap(cm);
            LightMap lmRain = cmRain != null ? new LightMap(cmRain) : null;
            LightMap lmThunder = cmThunder != null ? new LightMap(cmThunder) : null;
            lmps[i] = lmp = new LightMapPack(lm, lmRain, lmThunder);
        }
        return new ImmutablePair((Object)lmps, (Object)minDimId);
    }

    private static int getTextureHeight(String path, int defHeight) {
        try {
            InputStream in = Config.getResourceStream((aaj)new aaj(path));
            if (in == null) {
                return defHeight;
            }
            BufferedImage bi = ImageIO.read(in);
            in.close();
            if (bi == null) {
                return defHeight;
            }
            return bi.getHeight();
        }
        catch (IOException e) {
            return defHeight;
        }
    }

    private static void readColorProperties(String fileName) {
        try {
            float[][] dyeColors;
            aaj loc = new aaj(fileName);
            InputStream in = Config.getResourceStream((aaj)loc);
            if (in == null) {
                return;
            }
            CustomColors.dbg((String)("Loading " + fileName));
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            particleWaterColor = CustomColors.readColor((Properties)props, (String[])new String[]{"particle.water", "drop.water"});
            particlePortalColor = CustomColors.readColor((Properties)props, (String)"particle.portal");
            lilyPadColor = CustomColors.readColor((Properties)props, (String)"lilypad");
            expBarTextColor = CustomColors.readColor((Properties)props, (String)"text.xpbar");
            bossTextColor = CustomColors.readColor((Properties)props, (String)"text.boss");
            signTextColor = CustomColors.readColor((Properties)props, (String)"text.sign");
            fogColorNether = CustomColors.readColorVec3((Properties)props, (String)"fog.nether");
            fogColorEnd = CustomColors.readColorVec3((Properties)props, (String)"fog.end");
            skyColorEnd = CustomColors.readColorVec3((Properties)props, (String)"sky.end");
            colorsBlockColormaps = CustomColors.readCustomColormaps((Properties)props, (String)fileName);
            spawnEggPrimaryColors = CustomColors.readSpawnEggColors((Properties)props, (String)fileName, (String)"egg.shell.", (String)"Spawn egg shell");
            spawnEggSecondaryColors = CustomColors.readSpawnEggColors((Properties)props, (String)fileName, (String)"egg.spots.", (String)"Spawn egg spot");
            wolfCollarColors = CustomColors.readDyeColors((Properties)props, (String)fileName, (String)"collar.", (String)"Wolf collar");
            sheepColors = CustomColors.readDyeColors((Properties)props, (String)fileName, (String)"sheep.", (String)"Sheep");
            textColors = CustomColors.readTextColors((Properties)props, (String)fileName, (String)"text.code.", (String)"Text");
            int[] mapColors = CustomColors.readMapColors((Properties)props, (String)fileName, (String)"map.", (String)"Map");
            if (mapColors != null) {
                if (mapColorsOriginal == null) {
                    mapColorsOriginal = CustomColors.getMapColors();
                }
                CustomColors.setMapColors((int[])mapColors);
            }
            if ((dyeColors = CustomColors.readDyeColors((Properties)props, (String)fileName, (String)"dye.", (String)"Dye")) != null) {
                if (dyeColorsOriginal == null) {
                    dyeColorsOriginal = CustomColors.getDyeColors();
                }
                CustomColors.setDyeColors((float[][])dyeColors);
            }
            potionColors = CustomColors.readPotionColors((Properties)props, (String)fileName, (String)"potion.", (String)"Potion");
            xpOrbTime = Config.parseInt((String)props.getProperty("xporb.time"), (int)-1);
        }
        catch (FileNotFoundException e) {
            return;
        }
        catch (IOException e) {
            Config.warn((String)("Error parsing: " + fileName));
            Config.warn((String)(e.getClass().getName() + ": " + e.getMessage()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static CustomColormap[] readCustomColormaps(Properties props, String fileName) {
        void var7_9;
        ArrayList<CustomColormap> list = new ArrayList<CustomColormap>();
        String palettePrefix = "palette.block.";
        HashMap<String, String> map = new HashMap<String, String>();
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(palettePrefix)) continue;
            map.put(string, value);
        }
        String[] propNames = map.keySet().toArray(new String[map.size()]);
        boolean bl = false;
        while (var7_9 < propNames.length) {
            String name = propNames[var7_9];
            String value = props.getProperty(name);
            CustomColors.dbg((String)("Block palette: " + name + " = " + value));
            String path = name.substring(palettePrefix.length());
            String basePath = TextureUtils.getBasePath((String)fileName);
            path = TextureUtils.fixResourcePath((String)path, (String)basePath);
            CustomColormap colors = CustomColors.getCustomColors((String)path, (int)256, (int)-1);
            if (colors == null) {
                CustomColors.warn((String)("Colormap not found: " + path));
            } else {
                ConnectedParser cp = new ConnectedParser("CustomColors");
                MatchBlock[] mbs = cp.parseMatchBlocks(value);
                if (mbs == null || mbs.length <= 0) {
                    CustomColors.warn((String)("Invalid match blocks: " + value));
                } else {
                    for (int m = 0; m < mbs.length; ++m) {
                        MatchBlock mb = mbs[m];
                        colors.addMatchBlock(mb);
                    }
                    list.add(colors);
                }
            }
            ++var7_9;
        }
        if (list.size() <= 0) {
            return null;
        }
        CustomColormap[] customColormapArray = list.toArray(new CustomColormap[list.size()]);
        return customColormapArray;
    }

    private static CustomColormap[][] readBlockColormaps(String[] basePaths, CustomColormap[] basePalettes, int width, int height) {
        int i;
        Object[] paths = ResUtils.collectFiles((String[])basePaths, (String[])new String[]{".properties"});
        Arrays.sort(paths);
        ArrayList blockList = new ArrayList();
        for (i = 0; i < paths.length; ++i) {
            Object path = paths[i];
            CustomColors.dbg((String)("Block colormap: " + (String)path));
            try {
                aaj locFile = new aaj("minecraft", (String)path);
                InputStream in = Config.getResourceStream((aaj)locFile);
                if (in == null) {
                    CustomColors.warn((String)("File not found: " + (String)path));
                    continue;
                }
                PropertiesOrdered props = new PropertiesOrdered();
                props.load(in);
                in.close();
                CustomColormap cm = new CustomColormap((Properties)props, (String)path, width, height, paletteFormatDefault);
                if (!cm.isValid((String)path) || !cm.isValidMatchBlocks((String)path)) continue;
                CustomColors.addToBlockList((CustomColormap)cm, blockList);
                continue;
            }
            catch (FileNotFoundException e) {
                CustomColors.warn((String)("File not found: " + (String)path));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (basePalettes != null) {
            for (i = 0; i < basePalettes.length; ++i) {
                CustomColormap cm = basePalettes[i];
                CustomColors.addToBlockList((CustomColormap)cm, blockList);
            }
        }
        if (blockList.size() <= 0) {
            return null;
        }
        CustomColormap[][] cmArr = CustomColors.blockListToArray(blockList);
        return cmArr;
    }

    private static void addToBlockList(CustomColormap cm, List blockList) {
        int[] ids = cm.getMatchBlockIds();
        if (ids == null || ids.length <= 0) {
            CustomColors.warn((String)("No match blocks: " + Config.arrayToString((int[])ids)));
            return;
        }
        for (int i = 0; i < ids.length; ++i) {
            int blockId = ids[i];
            if (blockId < 0) {
                CustomColors.warn((String)("Invalid block ID: " + blockId));
                continue;
            }
            CustomColors.addToList((CustomColormap)cm, (List)blockList, (int)blockId);
        }
    }

    private static void addToList(CustomColormap cm, List list, int id) {
        while (id >= list.size()) {
            list.add(null);
        }
        ArrayList<CustomColormap> subList = (ArrayList<CustomColormap>)list.get(id);
        if (subList == null) {
            subList = new ArrayList<CustomColormap>();
            list.set(id, subList);
        }
        subList.add(cm);
    }

    private static CustomColormap[][] blockListToArray(List list) {
        CustomColormap[][] colArr = new CustomColormap[list.size()][];
        for (int i = 0; i < list.size(); ++i) {
            List subList = (List)list.get(i);
            if (subList == null) continue;
            CustomColormap[] subArr = subList.toArray(new CustomColormap[subList.size()]);
            colArr[i] = subArr;
        }
        return colArr;
    }

    private static int readColor(Properties props, String[] names) {
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            int col = CustomColors.readColor((Properties)props, (String)name);
            if (col < 0) continue;
            return col;
        }
        return -1;
    }

    private static int readColor(Properties props, String name) {
        String str = props.getProperty(name);
        if (str == null) {
            return -1;
        }
        int color = CustomColors.parseColor((String)(str = str.trim()));
        if (color < 0) {
            CustomColors.warn((String)("Invalid color: " + name + " = " + str));
            return color;
        }
        CustomColors.dbg((String)(name + " = " + str));
        return color;
    }

    private static int parseColor(String str) {
        if (str == null) {
            return -1;
        }
        str = str.trim();
        try {
            int val = Integer.parseInt(str, 16) & 0xFFFFFF;
            return val;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static dvt readColorVec3(Properties props, String name) {
        int col = CustomColors.readColor((Properties)props, (String)name);
        if (col < 0) {
            return null;
        }
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        return new dvt((double)redF, (double)greenF, (double)blueF);
    }

    private static CustomColormap getCustomColors(String basePath, String[] paths, int width, int height) {
        for (int i = 0; i < paths.length; ++i) {
            Object path = paths[i];
            CustomColormap cols = CustomColors.getCustomColors((String)(path = basePath + (String)path), (int)width, (int)height);
            if (cols == null) continue;
            return cols;
        }
        return null;
    }

    public static CustomColormap getCustomColors(String pathImage, int width, int height) {
        try {
            aaj loc = new aaj(pathImage);
            if (!Config.hasResource((aaj)loc)) {
                return null;
            }
            CustomColors.dbg((String)("Colormap " + pathImage));
            PropertiesOrdered props = new PropertiesOrdered();
            String pathProps = StrUtils.replaceSuffix((String)pathImage, (String)".png", (String)".properties");
            aaj locProps = new aaj(pathProps);
            if (Config.hasResource((aaj)locProps)) {
                InputStream in = Config.getResourceStream((aaj)locProps);
                props.load(in);
                in.close();
                CustomColors.dbg((String)("Colormap properties: " + pathProps));
            } else {
                props.put("format", paletteFormatDefault);
                props.put("source", pathImage);
                pathProps = pathImage;
            }
            CustomColormap cm = new CustomColormap((Properties)props, pathProps, width, height, paletteFormatDefault);
            if (!cm.isValid(pathProps)) {
                return null;
            }
            return cm;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void updateUseDefaultGrassFoliageColors() {
        useDefaultGrassFoliageColors = foliageBirchColors == null && foliagePineColors == null && swampGrassColors == null && swampFoliageColors == null && Config.isSwampColors();
    }

    public static int getColorMultiplier(eyo quad, cur blockState, cfd blockAccess, gt blockPos, RenderEnv renderEnv) {
        return CustomColors.getColorMultiplier((boolean)quad.c(), (cur)blockState, (cfd)blockAccess, (gt)blockPos, (RenderEnv)renderEnv);
    }

    public static int getColorMultiplier(boolean quadHasTintIndex, cur blockState, cfd blockAccess, gt blockPos, RenderEnv renderEnv) {
        IColorizer colorizer;
        ciw block = blockState.b();
        cur blockStateColormap = blockState;
        if (blockColormaps != null) {
            CustomColormap cm;
            if (!quadHasTintIndex) {
                if (block == cix.i) {
                    blockStateColormap = BLOCK_STATE_DIRT;
                }
                if (block == cix.ch) {
                    return -1;
                }
            }
            if (block instanceof cku && blockState.c((cvu)cku.a) == cvn.a) {
                blockPos = blockPos.c();
                blockStateColormap = blockAccess.a_(blockPos);
            }
            if ((cm = CustomColors.getBlockColormap((cur)blockStateColormap)) != null) {
                if (Config.isSmoothBiomes() && !cm.isColorConstant()) {
                    return CustomColors.getSmoothColorMultiplier((cur)blockState, (cfd)blockAccess, (gt)blockPos, (IColorizer)cm, (BlockPosM)renderEnv.getColorizerBlockPosM());
                }
                return cm.getColor(blockAccess, blockPos);
            }
        }
        if (!quadHasTintIndex) {
            return -1;
        }
        if (block == cix.et) {
            return CustomColors.getLilypadColorMultiplier((cfd)blockAccess, (gt)blockPos);
        }
        if (block == cix.ch) {
            return CustomColors.getRedstoneColor((cur)renderEnv.getBlockState());
        }
        if (block instanceof cqi) {
            return CustomColors.getStemColorMultiplier((cur)blockState, (cfg)blockAccess, (gt)blockPos, (RenderEnv)renderEnv);
        }
        if (useDefaultGrassFoliageColors) {
            return -1;
        }
        if (block == cix.i || block instanceof cqs || block instanceof cku || block == cix.db) {
            colorizer = COLORIZER_GRASS;
        } else if (block instanceof cku) {
            colorizer = COLORIZER_GRASS;
            if (blockState.c((cvu)cku.a) == cvn.a) {
                blockPos = blockPos.c();
            }
        } else if (block instanceof cmw) {
            colorizer = block == cix.as ? COLORIZER_FOLIAGE : (block == cix.at ? COLORIZER_FOLIAGE_PINE : (block == cix.au ? COLORIZER_FOLIAGE_BIRCH : COLORIZER_FOLIAGE));
        } else if (block == cix.em) {
            colorizer = COLORIZER_FOLIAGE;
        } else {
            return -1;
        }
        if (Config.isSmoothBiomes() && !colorizer.isColorConstant()) {
            return CustomColors.getSmoothColorMultiplier((cur)blockState, (cfd)blockAccess, (gt)blockPos, (IColorizer)colorizer, (BlockPosM)renderEnv.getColorizerBlockPosM());
        }
        return colorizer.getColor(blockStateColormap, blockAccess, blockPos);
    }

    protected static cgw getColorBiome(cfd blockAccess, gt blockPos) {
        cgw biome = BiomeUtils.getBiome((cfd)blockAccess, (gt)blockPos);
        if (!(biome != BiomeUtils.SWAMP && biome != BiomeUtils.SWAMP_HILLS || Config.isSwampColors())) {
            biome = BiomeUtils.PLAINS;
        }
        return biome;
    }

    private static CustomColormap getBlockColormap(cur blockState) {
        if (blockColormaps == null) {
            return null;
        }
        if (!(blockState instanceof cur)) {
            return null;
        }
        cur bs = blockState;
        int blockId = bs.getBlockId();
        if (blockId < 0 || blockId >= blockColormaps.length) {
            return null;
        }
        CustomColormap[] cms2 = blockColormaps[blockId];
        if (cms2 == null) {
            return null;
        }
        for (int i = 0; i < cms2.length; ++i) {
            CustomColormap cm = cms2[i];
            if (!cm.matchesBlock(bs)) continue;
            return cm;
        }
        return null;
    }

    private static int getSmoothColorMultiplier(cur blockState, cfd blockAccess, gt blockPos, IColorizer colorizer, BlockPosM blockPosM) {
        int sumRed = 0;
        int sumGreen = 0;
        int sumBlue = 0;
        int x = blockPos.u();
        int y = blockPos.v();
        int z = blockPos.w();
        BlockPosM posM = blockPosM;
        int radius = Config.getBiomeBlendRadius();
        int width = radius * 2 + 1;
        int count = width * width;
        for (int ix = x - radius; ix <= x + radius; ++ix) {
            for (int iz = z - radius; iz <= z + radius; ++iz) {
                posM.setXyz(ix, y, iz);
                int col = colorizer.getColor(blockState, blockAccess, (gt)posM);
                sumRed += col >> 16 & 0xFF;
                sumGreen += col >> 8 & 0xFF;
                sumBlue += col & 0xFF;
            }
        }
        int r = sumRed / count;
        int g = sumGreen / count;
        int b2 = sumBlue / count;
        return r << 16 | g << 8 | b2;
    }

    public static int getFluidColor(cfd blockAccess, cur blockState, gt blockPos, RenderEnv renderEnv) {
        ciw block = blockState.b();
        CustomColormap colorizer = CustomColors.getBlockColormap((cur)blockState);
        if (colorizer == null && blockState.d() == dpc.j) {
            colorizer = COLORIZER_WATER;
        }
        if (colorizer == null) {
            return CustomColors.getBlockColors().a(blockState, blockAccess, blockPos, 0);
        }
        if (Config.isSmoothBiomes() && !colorizer.isColorConstant()) {
            return CustomColors.getSmoothColorMultiplier((cur)blockState, (cfd)blockAccess, (gt)blockPos, (IColorizer)colorizer, (BlockPosM)renderEnv.getColorizerBlockPosM());
        }
        return colorizer.getColor(blockState, blockAccess, blockPos);
    }

    public static efv getBlockColors() {
        return eev.G().am();
    }

    public static void updatePortalFX(evm fx) {
        if (particlePortalColor < 0) {
            return;
        }
        int col = particlePortalColor;
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        fx.a(redF, greenF, blueF);
    }

    public static void updateLavaFX(evm fx) {
        if (lavaDropColors == null) {
            return;
        }
        int age = fx.getAge();
        int col = lavaDropColors.getColor(age);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        fx.a(redF, greenF, blueF);
    }

    public static void updateMyceliumFX(evm fx) {
        if (myceliumParticleColors == null) {
            return;
        }
        int col = myceliumParticleColors.getColorRandom();
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        fx.a(redF, greenF, blueF);
    }

    private static int getRedstoneColor(cur blockState) {
        if (redstoneColors == null) {
            return -1;
        }
        int level = CustomColors.getRedstoneLevel((cur)blockState, (int)15);
        int col = redstoneColors.getColor(level);
        return col;
    }

    public static void updateReddustFX(evm fx, cfd blockAccess, double x, double y, double z) {
        if (redstoneColors == null) {
            return;
        }
        cur state = blockAccess.a_(new gt(x, y, z));
        int level = CustomColors.getRedstoneLevel((cur)state, (int)15);
        int col = redstoneColors.getColor(level);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        fx.a(redF, greenF, blueF);
    }

    private static int getRedstoneLevel(cur state, int def) {
        ciw block = state.b();
        if (!(block instanceof coo)) {
            return def;
        }
        Comparable val = state.c((cvu)coo.e);
        if (!(val instanceof Integer)) {
            return def;
        }
        Integer valInt = (Integer)val;
        return valInt;
    }

    public static float getXpOrbTimer(float timer) {
        if (xpOrbTime <= 0) {
            return timer;
        }
        float kt = 628.0f / (float)xpOrbTime;
        return timer * kt;
    }

    public static int getXpOrbColor(float timer) {
        if (xpOrbColors == null) {
            return -1;
        }
        int index = (int)Math.round((double)((alp.a((float)timer) + 1.0f) * (float)(xpOrbColors.getLength() - 1)) / 2.0);
        int col = xpOrbColors.getColor(index);
        return col;
    }

    public static int getDurabilityColor(float dur, int color) {
        if (durabilityColors == null) {
            return color;
        }
        int index = (int)(dur * (float)durabilityColors.getLength());
        int col = durabilityColors.getColor(index);
        return col;
    }

    public static void updateWaterFX(evm fx, cfd blockAccess, double x, double y, double z, RenderEnv renderEnv) {
        if (waterColors == null && blockColormaps == null && particleWaterColor < 0) {
            return;
        }
        gt blockPos = new gt(x, y, z);
        renderEnv.reset(BLOCK_STATE_WATER, blockPos);
        int col = CustomColors.getFluidColor((cfd)blockAccess, (cur)BLOCK_STATE_WATER, (gt)blockPos, (RenderEnv)renderEnv);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        if (particleWaterColor >= 0) {
            int redDrop = particleWaterColor >> 16 & 0xFF;
            int greenDrop = particleWaterColor >> 8 & 0xFF;
            int blueDrop = particleWaterColor & 0xFF;
            redF = (float)redDrop / 255.0f;
            greenF = (float)greenDrop / 255.0f;
            blueF = (float)blueDrop / 255.0f;
            redF *= (float)redDrop / 255.0f;
            greenF *= (float)greenDrop / 255.0f;
            blueF *= (float)blueDrop / 255.0f;
        }
        fx.a(redF, greenF, blueF);
    }

    private static int getLilypadColorMultiplier(cfd blockAccess, gt blockPos) {
        if (lilyPadColor < 0) {
            return CustomColors.getBlockColors().a(cix.et.m(), blockAccess, blockPos, 0);
        }
        return lilyPadColor;
    }

    private static dvt getFogColorNether(dvt col) {
        if (fogColorNether == null) {
            return col;
        }
        return fogColorNether;
    }

    private static dvt getFogColorEnd(dvt col) {
        if (fogColorEnd == null) {
            return col;
        }
        return fogColorEnd;
    }

    private static dvt getSkyColorEnd(dvt col) {
        if (skyColorEnd == null) {
            return col;
        }
        return skyColorEnd;
    }

    public static dvt getSkyColor(dvt skyColor3d, cfd blockAccess, double x, double y, double z) {
        if (skyColors == null) {
            return skyColor3d;
        }
        int col = skyColors.getColorSmooth(blockAccess, x, y, z, 3);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        float cRed = (float)skyColor3d.c / 0.5f;
        float cGreen = (float)skyColor3d.d / 0.66275f;
        float cBlue = (float)skyColor3d.e;
        dvt newCol = skyColorFader.getColor((double)(redF *= cRed), (double)(greenF *= cGreen), (double)(blueF *= cBlue));
        return newCol;
    }

    private static dvt getFogColor(dvt fogColor3d, cfd blockAccess, double x, double y, double z) {
        if (fogColors == null) {
            return fogColor3d;
        }
        int col = fogColors.getColorSmooth(blockAccess, x, y, z, 3);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        float cRed = (float)fogColor3d.c / 0.753f;
        float cGreen = (float)fogColor3d.d / 0.8471f;
        float cBlue = (float)fogColor3d.e;
        dvt newCol = fogColorFader.getColor((double)(redF *= cRed), (double)(greenF *= cGreen), (double)(blueF *= cBlue));
        return newCol;
    }

    public static dvt getUnderwaterColor(cfd blockAccess, double x, double y, double z) {
        return CustomColors.getUnderFluidColor((cfd)blockAccess, (double)x, (double)y, (double)z, (CustomColormap)underwaterColors, (CustomColorFader)underwaterColorFader);
    }

    public static dvt getUnderlavaColor(cfd blockAccess, double x, double y, double z) {
        return CustomColors.getUnderFluidColor((cfd)blockAccess, (double)x, (double)y, (double)z, (CustomColormap)underlavaColors, (CustomColorFader)underlavaColorFader);
    }

    public static dvt getUnderFluidColor(cfd blockAccess, double x, double y, double z, CustomColormap underFluidColors, CustomColorFader underFluidColorFader) {
        if (underFluidColors == null) {
            return null;
        }
        int col = underFluidColors.getColorSmooth(blockAccess, x, y, z, 3);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        dvt newCol = underFluidColorFader.getColor((double)redF, (double)greenF, (double)blueF);
        return newCol;
    }

    private static int getStemColorMultiplier(cur blockState, cfg blockAccess, gt blockPos, RenderEnv renderEnv) {
        CustomColormap colors = stemColors;
        ciw blockStem = blockState.b();
        if (blockStem == cix.ek && stemPumpkinColors != null) {
            colors = stemPumpkinColors;
        }
        if (blockStem == cix.el && stemMelonColors != null) {
            colors = stemMelonColors;
        }
        if (colors == null) {
            return -1;
        }
        if (!(blockStem instanceof cqi)) {
            return -1;
        }
        int level = (Integer)blockState.c((cvu)cqi.b);
        return colors.getColor(level);
    }

    public static boolean updateLightmap(etm world, float torchFlickerX, dyt lmColors, boolean nightvision, float darkLight, float partialTicks) {
        if (world == null) {
            return false;
        }
        if (lightMapPacks == null) {
            return false;
        }
        int dimensionId = WorldUtils.getDimensionId((cga)world);
        int lightMapIndex = dimensionId - lightmapMinDimensionId;
        if (lightMapIndex < 0 || lightMapIndex >= lightMapPacks.length) {
            return false;
        }
        LightMapPack lightMapPack = lightMapPacks[lightMapIndex];
        if (lightMapPack == null) {
            return false;
        }
        return lightMapPack.updateLightmap(world, torchFlickerX, lmColors, nightvision, darkLight, partialTicks);
    }

    public static dvt getWorldFogColor(dvt fogVec, cga world, baq renderViewEntity, float partialTicks) {
        eev mc = eev.G();
        if (WorldUtils.isNether((cga)world)) {
            return CustomColors.getFogColorNether((dvt)fogVec);
        }
        if (WorldUtils.isOverworld((cga)world)) {
            return CustomColors.getFogColor((dvt)fogVec, (cfd)mc.r, (double)renderViewEntity.dg(), (double)(renderViewEntity.di() + 1.0), (double)renderViewEntity.dm());
        }
        if (WorldUtils.isEnd((cga)world)) {
            return CustomColors.getFogColorEnd((dvt)fogVec);
        }
        return fogVec;
    }

    public static dvt getWorldSkyColor(dvt skyVec, cga world, baq renderViewEntity, float partialTicks) {
        eev mc = eev.G();
        if (WorldUtils.isOverworld((cga)world) && renderViewEntity != null) {
            return CustomColors.getSkyColor((dvt)skyVec, (cfd)mc.r, (double)renderViewEntity.dg(), (double)(renderViewEntity.di() + 1.0), (double)renderViewEntity.dm());
        }
        if (WorldUtils.isEnd((cga)world)) {
            return CustomColors.getSkyColorEnd((dvt)skyVec);
        }
        return skyVec;
    }

    /*
     * WARNING - void declaration
     */
    private static int[] readSpawnEggColors(Properties props, String fileName, String prefix, String logName) {
        void var8_10;
        ArrayList<Integer> list = new ArrayList<Integer>();
        Set<Object> keys = props.keySet();
        int countColors = 0;
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(prefix)) continue;
            String name = StrUtils.removePrefix((String)string, (String)prefix);
            int id = EntityUtils.getEntityIdByName((String)name);
            try {
                if (id < 0) {
                    id = EntityUtils.getEntityIdByLocation((String)new aaj(name).toString());
                }
            }
            catch (aa e) {
                Config.warn((String)("ResourceLocationException: " + e.getMessage()));
            }
            if (id < 0) {
                CustomColors.warn((String)("Invalid spawn egg name: " + string));
                continue;
            }
            int color = CustomColors.parseColor((String)value);
            if (color < 0) {
                CustomColors.warn((String)("Invalid spawn egg color: " + string + " = " + value));
                continue;
            }
            while (list.size() <= id) {
                list.add(-1);
            }
            list.set(id, color);
            ++countColors;
        }
        if (countColors <= 0) {
            return null;
        }
        CustomColors.dbg((String)(logName + " colors: " + countColors));
        int[] colors = new int[list.size()];
        boolean bl = false;
        while (var8_10 < colors.length) {
            colors[var8_10] = (Integer)list.get((int)var8_10);
            ++var8_10;
        }
        return colors;
    }

    private static int getSpawnEggColor(cbc item, caa itemStack, int layer, int color) {
        int[] eggColors;
        if (spawnEggPrimaryColors == null && spawnEggSecondaryColors == null) {
            return color;
        }
        bau entityType = item.a(itemStack.u());
        if (entityType == null) {
            return color;
        }
        int id = hm.X.a((Object)entityType);
        if (id < 0) {
            return color;
        }
        int[] nArray = eggColors = layer == 0 ? spawnEggPrimaryColors : spawnEggSecondaryColors;
        if (eggColors == null) {
            return color;
        }
        if (id < 0 || id >= eggColors.length) {
            return color;
        }
        int eggColor = eggColors[id];
        if (eggColor < 0) {
            return color;
        }
        return eggColor;
    }

    public static int getColorFromItemStack(caa itemStack, int layer, int color) {
        if (itemStack == null) {
            return color;
        }
        bzw item = itemStack.c();
        if (item == null) {
            return color;
        }
        if (item instanceof cbc) {
            return CustomColors.getSpawnEggColor((cbc)((cbc)item), (caa)itemStack, (int)layer, (int)color);
        }
        if (item == cac.fi && lilyPadColor != -1) {
            return lilyPadColor;
        }
        return color;
    }

    private static float[][] readDyeColors(Properties props, String fileName, String prefix, String logName) {
        byt[] dyeValues = byt.values();
        HashMap<String, byt> mapDyes = new HashMap<String, byt>();
        for (int i = 0; i < dyeValues.length; ++i) {
            byt dye = dyeValues[i];
            mapDyes.put(dye.c(), dye);
        }
        mapDyes.put("lightBlue", byt.d);
        mapDyes.put("silver", byt.i);
        float[][] colors = new float[dyeValues.length][];
        int countColors = 0;
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(prefix)) continue;
            String name = StrUtils.removePrefix((String)string, (String)prefix);
            byt dye = (byt)mapDyes.get(name);
            int color = CustomColors.parseColor((String)value);
            if (dye == null || color < 0) {
                CustomColors.warn((String)("Invalid color: " + string + " = " + value));
                continue;
            }
            float[] rgb = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
            colors[dye.ordinal()] = rgb;
            ++countColors;
        }
        if (countColors <= 0) {
            return null;
        }
        CustomColors.dbg((String)(logName + " colors: " + countColors));
        return colors;
    }

    private static float[] getDyeColors(byt dye, float[][] dyeColors, float[] colors) {
        if (dyeColors == null) {
            return colors;
        }
        if (dye == null) {
            return colors;
        }
        float[] customColors = dyeColors[dye.ordinal()];
        if (customColors == null) {
            return colors;
        }
        return customColors;
    }

    public static float[] getWolfCollarColors(byt dye, float[] colors) {
        return CustomColors.getDyeColors((byt)dye, (float[][])wolfCollarColors, (float[])colors);
    }

    public static float[] getSheepColors(byt dye, float[] colors) {
        return CustomColors.getDyeColors((byt)dye, (float[][])sheepColors, (float[])colors);
    }

    private static int[] readTextColors(Properties props, String fileName, String prefix, String logName) {
        int[] colors = new int[32];
        Arrays.fill(colors, -1);
        int countColors = 0;
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(prefix)) continue;
            String name = StrUtils.removePrefix((String)string, (String)prefix);
            int code = Config.parseInt((String)name, (int)-1);
            int color = CustomColors.parseColor((String)value);
            if (code < 0 || code >= colors.length || color < 0) {
                CustomColors.warn((String)("Invalid color: " + string + " = " + value));
                continue;
            }
            colors[code] = color;
            ++countColors;
        }
        if (countColors <= 0) {
            return null;
        }
        CustomColors.dbg((String)(logName + " colors: " + countColors));
        return colors;
    }

    public static int getTextColor(int index, int color) {
        if (textColors == null) {
            return color;
        }
        if (index < 0 || index >= textColors.length) {
            return color;
        }
        int customColor = textColors[index];
        if (customColor < 0) {
            return color;
        }
        return customColor;
    }

    private static int[] readMapColors(Properties props, String fileName, String prefix, String logName) {
        int[] colors = new int[dpd.am.length];
        Arrays.fill(colors, -1);
        int countColors = 0;
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(prefix)) continue;
            String name = StrUtils.removePrefix((String)string, (String)prefix);
            int index = CustomColors.getMapColorIndex((String)name);
            int color = CustomColors.parseColor((String)value);
            if (index < 0 || index >= colors.length || color < 0) {
                CustomColors.warn((String)("Invalid color: " + string + " = " + value));
                continue;
            }
            colors[index] = color;
            ++countColors;
        }
        if (countColors <= 0) {
            return null;
        }
        CustomColors.dbg((String)(logName + " colors: " + countColors));
        return colors;
    }

    private static int[] readPotionColors(Properties props, String fileName, String prefix, String logName) {
        int[] colors = new int[CustomColors.getMaxPotionId()];
        Arrays.fill(colors, -1);
        int countColors = 0;
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(prefix)) continue;
            String name = string;
            int index = CustomColors.getPotionId((String)name);
            int color = CustomColors.parseColor((String)value);
            if (index < 0 || index >= colors.length || color < 0) {
                CustomColors.warn((String)("Invalid color: " + string + " = " + value));
                continue;
            }
            colors[index] = color;
            ++countColors;
        }
        if (countColors <= 0) {
            return null;
        }
        CustomColors.dbg((String)(logName + " colors: " + countColors));
        return colors;
    }

    private static int getMaxPotionId() {
        int maxId = 0;
        Set keys = hm.U.d();
        for (aaj rl : keys) {
            bah potion = PotionUtils.getPotion((aaj)rl);
            int id = bah.a((bah)potion);
            if (id <= maxId) continue;
            maxId = id;
        }
        return maxId;
    }

    private static int getPotionId(String name) {
        if (name.equals("potion.water")) {
            return 0;
        }
        name = StrUtils.replacePrefix((String)name, (String)"potion.", (String)"effect.");
        String nameMc = StrUtils.replacePrefix((String)name, (String)"effect.", (String)"effect.minecraft.");
        Set keys = hm.U.d();
        for (aaj rl : keys) {
            bah potion = PotionUtils.getPotion((aaj)rl);
            if (potion.d().equals(name)) {
                return bah.a((bah)potion);
            }
            if (!potion.d().equals(nameMc)) continue;
            return bah.a((bah)potion);
        }
        return -1;
    }

    public static int getPotionColor(bah potion, int color) {
        int potionId = 0;
        if (potion != null) {
            potionId = bah.a((bah)potion);
        }
        return CustomColors.getPotionColor((int)potionId, (int)color);
    }

    public static int getPotionColor(int potionId, int color) {
        if (potionColors == null) {
            return color;
        }
        if (potionId < 0 || potionId >= potionColors.length) {
            return color;
        }
        int potionColor = potionColors[potionId];
        if (potionColor < 0) {
            return color;
        }
        return potionColor;
    }

    private static int getMapColorIndex(String name) {
        if (name == null) {
            return -1;
        }
        if (name.equals("air")) {
            return dpd.a.al;
        }
        if (name.equals("grass")) {
            return dpd.b.al;
        }
        if (name.equals("sand")) {
            return dpd.c.al;
        }
        if (name.equals("cloth")) {
            return dpd.d.al;
        }
        if (name.equals("tnt")) {
            return dpd.e.al;
        }
        if (name.equals("ice")) {
            return dpd.f.al;
        }
        if (name.equals("iron")) {
            return dpd.g.al;
        }
        if (name.equals("foliage")) {
            return dpd.h.al;
        }
        if (name.equals("clay")) {
            return dpd.j.al;
        }
        if (name.equals("dirt")) {
            return dpd.k.al;
        }
        if (name.equals("stone")) {
            return dpd.l.al;
        }
        if (name.equals("water")) {
            return dpd.m.al;
        }
        if (name.equals("wood")) {
            return dpd.n.al;
        }
        if (name.equals("quartz")) {
            return dpd.o.al;
        }
        if (name.equals("gold")) {
            return dpd.E.al;
        }
        if (name.equals("diamond")) {
            return dpd.F.al;
        }
        if (name.equals("lapis")) {
            return dpd.G.al;
        }
        if (name.equals("emerald")) {
            return dpd.H.al;
        }
        if (name.equals("obsidian")) {
            return dpd.I.al;
        }
        if (name.equals("netherrack")) {
            return dpd.J.al;
        }
        if (name.equals("snow") || name.equals("white")) {
            return dpd.i.al;
        }
        if (name.equals("adobe") || name.equals("orange")) {
            return dpd.p.al;
        }
        if (name.equals("magenta")) {
            return dpd.q.al;
        }
        if (name.equals("light_blue") || name.equals("lightBlue")) {
            return dpd.r.al;
        }
        if (name.equals("yellow")) {
            return dpd.s.al;
        }
        if (name.equals("lime")) {
            return dpd.t.al;
        }
        if (name.equals("pink")) {
            return dpd.u.al;
        }
        if (name.equals("gray")) {
            return dpd.v.al;
        }
        if (name.equals("silver") || name.equals("light_gray")) {
            return dpd.w.al;
        }
        if (name.equals("cyan")) {
            return dpd.x.al;
        }
        if (name.equals("purple")) {
            return dpd.y.al;
        }
        if (name.equals("blue")) {
            return dpd.z.al;
        }
        if (name.equals("brown")) {
            return dpd.A.al;
        }
        if (name.equals("green")) {
            return dpd.B.al;
        }
        if (name.equals("red")) {
            return dpd.C.al;
        }
        if (name.equals("black")) {
            return dpd.D.al;
        }
        if (name.equals("white_terracotta")) {
            return dpd.K.al;
        }
        if (name.equals("orange_terracotta")) {
            return dpd.L.al;
        }
        if (name.equals("magenta_terracotta")) {
            return dpd.M.al;
        }
        if (name.equals("light_blue_terracotta")) {
            return dpd.N.al;
        }
        if (name.equals("yellow_terracotta")) {
            return dpd.O.al;
        }
        if (name.equals("lime_terracotta")) {
            return dpd.P.al;
        }
        if (name.equals("pink_terracotta")) {
            return dpd.Q.al;
        }
        if (name.equals("gray_terracotta")) {
            return dpd.R.al;
        }
        if (name.equals("light_gray_terracotta")) {
            return dpd.S.al;
        }
        if (name.equals("cyan_terracotta")) {
            return dpd.T.al;
        }
        if (name.equals("purple_terracotta")) {
            return dpd.U.al;
        }
        if (name.equals("blue_terracotta")) {
            return dpd.V.al;
        }
        if (name.equals("brown_terracotta")) {
            return dpd.W.al;
        }
        if (name.equals("green_terracotta")) {
            return dpd.X.al;
        }
        if (name.equals("red_terracotta")) {
            return dpd.Y.al;
        }
        if (name.equals("black_terracotta")) {
            return dpd.Z.al;
        }
        if (name.equals("crimson_nylium")) {
            return dpd.aa.al;
        }
        if (name.equals("crimson_stem")) {
            return dpd.ab.al;
        }
        if (name.equals("crimson_hyphae")) {
            return dpd.ac.al;
        }
        if (name.equals("warped_nylium")) {
            return dpd.ad.al;
        }
        if (name.equals("warped_stem")) {
            return dpd.ae.al;
        }
        if (name.equals("warped_hyphae")) {
            return dpd.af.al;
        }
        if (name.equals("warped_wart_block")) {
            return dpd.ag.al;
        }
        return -1;
    }

    private static int[] getMapColors() {
        dpd[] mapColors = dpd.am;
        int[] colors = new int[mapColors.length];
        Arrays.fill(colors, -1);
        for (int i = 0; i < mapColors.length && i < colors.length; ++i) {
            dpd mapColor = mapColors[i];
            if (mapColor == null) continue;
            colors[i] = mapColor.ak;
        }
        return colors;
    }

    private static void setMapColors(int[] colors) {
        if (colors == null) {
            return;
        }
        dpd[] mapColors = dpd.am;
        for (int i = 0; i < mapColors.length && i < colors.length; ++i) {
            int color;
            dpd mapColor = mapColors[i];
            if (mapColor == null || (color = colors[i]) < 0 || mapColor.ak == color) continue;
            mapColor.ak = color;
        }
    }

    private static float[][] getDyeColors() {
        byt[] dyeColors = byt.values();
        float[][] colors = new float[dyeColors.length][];
        for (int i = 0; i < dyeColors.length && i < colors.length; ++i) {
            byt dyeColor = dyeColors[i];
            if (dyeColor == null) continue;
            colors[i] = dyeColor.d();
        }
        return colors;
    }

    private static void setDyeColors(float[][] colors) {
        if (colors == null) {
            return;
        }
        byt[] dyeColors = byt.values();
        for (int i = 0; i < dyeColors.length && i < colors.length; ++i) {
            float[] color;
            byt dyeColor = dyeColors[i];
            if (dyeColor == null || (color = colors[i]) == null || dyeColor.d().equals(color)) continue;
            dyeColor.setColorComponentValues(color);
        }
    }

    private static void dbg(String str) {
        Config.dbg((String)("CustomColors: " + str));
    }

    private static void warn(String str) {
        Config.warn((String)("CustomColors: " + str));
    }

    public static int getExpBarTextColor(int color) {
        if (expBarTextColor < 0) {
            return color;
        }
        return expBarTextColor;
    }

    public static int getBossTextColor(int color) {
        if (bossTextColor < 0) {
            return color;
        }
        return bossTextColor;
    }

    public static int getSignTextColor(int color) {
        if (color != 0) {
            return color;
        }
        if (signTextColor < 0) {
            return color;
        }
        return signTextColor;
    }
}

