/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import java.util.ArrayList;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.util.Either;

public abstract class ModelAdapter {
    private Either<awx, cmb> type;
    private String name;
    private float shadowSize;
    private String[] aliases;

    public ModelAdapter(awx entityType, String name, float shadowSize) {
        this(Either.makeLeft((Object)entityType), name, shadowSize, null);
    }

    public ModelAdapter(awx entityType, String name, float shadowSize, String[] aliases) {
        this(Either.makeLeft((Object)entityType), name, shadowSize, aliases);
    }

    public ModelAdapter(cmb tileEntityType, String name, float shadowSize) {
        this(Either.makeRight((Object)tileEntityType), name, shadowSize, null);
    }

    public ModelAdapter(cmb tileEntityType, String name, float shadowSize, String[] aliases) {
        this(Either.makeRight((Object)tileEntityType), name, shadowSize, aliases);
    }

    public ModelAdapter(Either<awx, cmb> type, String name, float shadowSize, String[] aliases) {
        this.type = type;
        this.name = name;
        this.shadowSize = shadowSize;
        this.aliases = aliases;
    }

    public Either<awx, cmb> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public float getShadowSize() {
        return this.shadowSize;
    }

    public abstract eix makeModel();

    public abstract eku getModelRenderer(eix var1, String var2);

    public abstract String[] getModelRendererNames();

    public abstract IEntityRenderer makeEntityRender(eix var1, float var2);

    public boolean setTextureLocation(IEntityRenderer er, yh textureLocation) {
        return false;
    }

    public eku[] getModelRenderers(eix model) {
        String[] names = this.getModelRendererNames();
        ArrayList<eku> list = new ArrayList<eku>();
        for (int i2 = 0; i2 < names.length; ++i2) {
            String name = names[i2];
            eku mr = this.getModelRenderer(model, name);
            if (mr == null) continue;
            list.add(mr);
        }
        eku[] mrs = list.toArray(new eku[list.size()]);
        return mrs;
    }

    public static eku bakeModelLayer(eks loc) {
        return dxo.D().ab().getContext().a(loc);
    }
}

