/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.integration.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import java.util.LinkedList;
import java.util.List;

public class CraftTweakerIntegration {
    public static final String CLASS_PREFIX = "mods.cfm.";
    private static final List<IAction> ACTIONS = new LinkedList<IAction>();

    public static void defer(String description, Runnable action) {
        ACTIONS.add(new DeferredAction(description, action));
    }

    public static void apply() {
        CraftTweakerAPI.logInfo((String)"Applying MrCrayfish's Furniture Mod changes...");
        ACTIONS.forEach(action -> {
            try {
                CraftTweakerAPI.apply((IAction)action);
            }
            catch (Exception ex) {
                CraftTweakerAPI.logError((String)("Exception whilst applying \"" + action.describe() + "\""), (Throwable)ex);
            }
        });
    }

    private static class DeferredAction
    implements IAction {
        private final String description;
        private final Runnable func;

        public DeferredAction(String description, Runnable func) {
            this.description = description;
            this.func = func;
        }

        public void apply() {
            this.func.run();
        }

        public String describe() {
            return this.description;
        }
    }
}

